#include <iostream>
#include <fstream>
#include <cmath>
#include <cstdlib>
using namespace std;
#include "size.h"

#define   MaxLastMember 199
#define   MaxLastNode    99

void Invert(int n,double C[][Max_n+1],double B[][Max_n+1]);
void DrawStructure(void);
void dxfSetUp(void);
void dxfMember(void);
void dxfLoad(void);
void dxfMemberNo(void);
void dxfNodeNo(void);
void dxfNodeCircle(void);

void dxfFinishOff(void);

int   End[2][MaxLastMember+1],Fixed[Max_n+1],
      Member,LastMember,Node,LastNode,
      tempint,
      Direction,last_dof,
      thiscoord,thatcoord,thisend,thatend,
	  this_dof,that_dof;

double x[2][MaxLastNode+1],Load[Max_n+1],p[Max_n+1],delta[Max_n+1],K[Max_n+1][Max_n+1],
       Flex[Max_n+1][Max_n+1],
       EA[MaxLastMember+1],xDiff[2][MaxLastMember+1],L[MaxLastMember+1],
       Lsq,textcircsize,thisstiffness,MemberTension;

ifstream mems("members.txt"),nods("nodes.txt"),lds("loads.txt"),sup("supports.txt");
ofstream Picy("structure.dxf");
ofstream Tension("MemberTensions.txt");

int main(void)
{
if(2*MaxLastNode+2>Max_n+1){cout<<"Problem with sizes\n";return 0;}

mems>>LastMember;if(LastMember>MaxLastMember){cout<<"Too many members\n";return 0;}
for(tempint=0;tempint<=LastMember;tempint++){mems>>Member;mems>>End[0][Member]>>End[1][Member]>>EA[Member];}
mems.close();

nods>>LastNode;if(LastNode>MaxLastNode){cout<<"Too many Nodes\n";return 0;}
for(tempint=0;tempint<=LastNode;tempint++){nods>>Node;nods>>x[0][Node]>>x[1][Node];}
nods.close();

last_dof=2*LastNode+1;

for(this_dof=0;this_dof<=last_dof;this_dof++)
{
Load[this_dof]=0.0;
delta[this_dof]=0.0;
Fixed[this_dof]=0;
for(that_dof=0;that_dof<=last_dof;that_dof++)K[this_dof][that_dof]=0.0;
}

for(;;)
{
lds>>Node;if(Node<0)break;
lds>>Direction;
lds>>Load[2*Node+Direction];
}

for(;;)
{
sup>>Node;if(Node<0)break;
sup>>Direction;
Fixed[2*Node+Direction]=1;
Load[2*Node+Direction]=0.0;
}

for(Member=0;Member<=LastMember;Member++)
{
Lsq=0.0;
for(thiscoord=0;thiscoord<=1;thiscoord++)
{
xDiff[thiscoord][Member]=x[thiscoord][End[1][Member]]-x[thiscoord][End[0][Member]];
Lsq+=xDiff[thiscoord][Member]*xDiff[thiscoord][Member];
}
L[Member]=sqrt(Lsq);

for(thiscoord=0;thiscoord<=1;thiscoord++)
{
for(thatcoord=0;thatcoord<=1;thatcoord++)
{
thisstiffness=(EA[Member]/(L[Member]*L[Member]*L[Member]))*xDiff[thiscoord][Member]*xDiff[thatcoord][Member];
for(thisend=0;thisend<=1;thisend++)
{
for(thatend=0;thatend<=1;thatend++)
{
this_dof=2*End[thisend][Member]+thiscoord;
that_dof=2*End[thatend][Member]+thatcoord;
if(thisend==thatend)
K[this_dof][that_dof]+=thisstiffness;
else
K[this_dof][that_dof]-=thisstiffness;
}
}
}
}
}

for(this_dof=0;this_dof<=last_dof;this_dof++)
{
if(Fixed[this_dof]==1)
{
K[this_dof][this_dof]=1.0;
for(that_dof=0;that_dof<=last_dof;that_dof++)
{
if(that_dof!=this_dof)
{
K[that_dof][this_dof]=0.0;
K[this_dof][that_dof]=0.0;
}
}
}
}

Invert(last_dof,K,Flex);

for(this_dof=0;this_dof<=last_dof;this_dof++)
{
for(that_dof=0;that_dof<=last_dof;that_dof++)
delta[this_dof]+=Flex[this_dof][that_dof]*Load[that_dof];
}

for(Member=0;Member<=LastMember;Member++)
{
MemberTension=(EA[Member]/(L[Member]*L[Member]))
*(xDiff[0][Member]*(delta[2*End[1][Member]+0]-delta[2*End[0][Member]+0])
 +xDiff[1][Member]*(delta[2*End[1][Member]+1]-delta[2*End[0][Member]+1]));
Tension<<Member<<"  "<<MemberTension<<"\n";
}
Tension.close();

DrawStructure();

cout<<"dxf file written, end of program.\n";
return 0;
}

void dxfSetUp(void)
{
Picy<<"0\n"<<"SECTION\n"<<"2\n"<<"ENTITIES\n";
}

void DrawStructure(void)
{
dxfSetUp();
textcircsize=0.05;
for(Member=0;Member<=LastMember;Member+=1)dxfMember();

for(Node=0;Node<=LastNode;Node+=1)dxfNodeCircle();

for(Member=0;Member<=LastMember;Member+=1)dxfMemberNo();

for(Node=0;Node<=LastNode;Node+=1)dxfNodeNo();

for(Node=0;Node<=LastNode;Node+=1)
{
for(Direction=0;Direction<=1;Direction++)
{if(Load[2*Node+Direction]!=0.0)dxfLoad();}
}

dxfFinishOff();
}

void dxfMember(void)
{
Picy<<"0\nLINE\n8\nUndeflected\n"
<<"10\n"<<x[0][End[0][Member]]<<"\n"
<<"20\n"<<x[1][End[0][Member]]<<"\n"
<<"11\n"<<x[0][End[1][Member]]<<"\n"
<<"21\n"<<x[1][End[1][Member]]<<"\n"
<<"62\n0\n";

Picy<<"0\nLINE\n8\nDeflected\n"
<<"10\n"<<x[0][End[0][Member]]+delta[2*End[0][Member]+0]<<"\n"
<<"20\n"<<x[1][End[0][Member]]+delta[2*End[0][Member]+1]<<"\n"
<<"11\n"<<x[0][End[1][Member]]+delta[2*End[1][Member]+0]<<"\n"
<<"21\n"<<x[1][End[1][Member]]+delta[2*End[1][Member]+1]<<"\n"
<<"62\n1\n";
}

void dxfNodeCircle(void)
{
Picy<<"0\nCIRCLE\n8\nUndeflected\n"
<<"10\n"<<x[0][Node]<<"\n"
<<"20\n"<<x[1][Node]<<"\n"
<<"40\n"<<textcircsize/2.0<<"\n"<<"62\n0\n";

Picy<<"0\nCIRCLE\n8\nDeflected\n"
<<"10\n"<<x[0][Node]+delta[2*Node+0]<<"\n"
<<"20\n"<<x[1][Node]+delta[2*Node+1]<<"\n"
<<"40\n"<<textcircsize/2.0<<"\n"<<"62\n1\n";
}

void dxfLoad(void)
{
Picy<<"0\nLINE\n8\nInformation\n"
<<"10\n"<<x[0][Node]<<"\n"
<<"20\n"<<x[1][Node]<<"\n";
if(Direction==0)
{
Picy<<"11\n"<<x[0][Node]+Load[2*Node+Direction]<<"\n"
<<"21\n"<<x[1][Node]<<"\n";
}
else
{
Picy<<"11\n"<<x[0][Node]<<"\n"
<<"21\n"<<x[1][Node]+Load[2*Node+Direction]<<"\n";
}
Picy<<"62\n1\n";
}

void dxfMemberNo(void)
{
Picy<<"0\nTEXT\n8\nInformation\n"
<<"10\n"<<(0.75*x[0][End[0][Member]]+0.25*x[0][End[1][Member]])<<"\n"
<<"20\n"<<(0.75*x[1][End[0][Member]]+0.25*x[1][End[1][Member]])<<"\n"
<<"40\n"<<textcircsize<<"\n"<<"62\n0\n"
<<"1\n"<<Member<<"\n";
}

void dxfNodeNo(void)
{
Picy<<"0\nTEXT\n8\nInformation\n"
<<"10\n"<<x[0][Node]+textcircsize<<"\n"
<<"20\n"<<x[1][Node]+textcircsize<<"\n"
<<"40\n"<<textcircsize<<"\n"<<"62\n0\n"
<<"1\n"<<Node<<"\n";
}

void dxfFinishOff(void)
{
Picy<<"0\n"<<"ENDSEC\n"<<"0\n"<<"EOF\n";
Picy.close();
}
