/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import peasy.PeasyCam;

public abstract class DampedAction {
    private final PeasyCam p;
    private double velocity;
    private double damping;
    private double targetRate = 60.0;
    private boolean targetlock = true;

    public DampedAction(PeasyCam p) {
        this(p, 0.16);
    }

    public DampedAction(PeasyCam p, double friction) {
        this.p = p;
        this.velocity = 0.0;
        this.damping = 1.0 - friction;
        p.getApplet().registerMethod("draw", (Object)this);
    }

    public void impulse(double impulse) {
        this.velocity = this.targetlock ? (this.velocity += impulse * Math.max(1.0, this.targetRate / (double)this.p.getApplet().frameRate)) : (this.velocity += impulse);
    }

    public void draw() {
        if (this.velocity == 0.0) {
            return;
        }
        this.behave(this.velocity);
        this.p.feed();
        this.velocity *= this.damping;
        if (Math.abs(this.velocity) < 0.001) {
            this.velocity = 0.0;
        }
    }

    public void stop() {
        this.velocity = 0.0;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setDamping(double damping) {
        this.damping = damping;
    }

    public void setSpeedRate(double targetRate) {
        this.targetRate = targetRate;
    }

    public void setSpeedLock(boolean lock) {
        this.targetlock = lock;
    }

    protected abstract void behave(double var1);
}

