/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import peasy.CameraState;
import peasy.DampedAction;
import peasy.EdgeMonitor;
import peasy.InterpolationManager;
import peasy.InterpolationUtil;
import peasy.PeasyDragHandler;
import peasy.PeasyWheelHandler;
import peasy.org.apache.commons.math.geometry.CardanEulerSingularityException;
import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.RotationOrder;
import peasy.org.apache.commons.math.geometry.Vector3D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PMatrix3D;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.event.TouchEvent;

public class PeasyCam {
    private static final Vector3D LOOK = Vector3D.plusK;
    private static final Vector3D UP = Vector3D.plusJ;
    private final PApplet p;
    private final double startDistance;
    private final Vector3D startCenter;
    private Vector3D panCenter;
    private boolean andriod = false;
    private boolean resetOnDoubleClick = true;
    private EdgeMonitor edgepan;
    private boolean mouseIsOverSketch;
    private boolean reversePan = false;
    private boolean reverseZoom = false;
    private boolean reverseRotate = false;
    private Point mouseExit;
    private double minimumDistance = 1.0;
    private double maximumDistance = Double.MAX_VALUE;
    private double maximumPanDistance = Double.MAX_VALUE;
    private final DampedAction rotateX;
    private final DampedAction rotateY;
    private final DampedAction rotateZ;
    private final DampedAction dampedZoom;
    private final DampedAction dampedPanX;
    private final DampedAction dampedPanY;
    private double distance;
    private Vector3D center;
    private Rotation rotation;
    private Constraint dragConstraint = null;
    private Constraint permaConstraint = null;
    private final InterpolationManager rotationInterps = new InterpolationManager();
    private final InterpolationManager centerInterps = new InterpolationManager();
    private final InterpolationManager distanceInterps = new InterpolationManager();
    private final PeasyDragHandler panHandler;
    private PeasyDragHandler centerDragHandler = this.panHandler = new PeasyDragHandler(){

        public void handleDrag(double d, double d2) {
            if (PeasyCam.this.reversePan) {
                d2 *= -1.0;
                d *= -1.0;
            }
            PeasyCam.this.dampedPanX.impulse(PeasyCam.this.panScale * d / 8.0);
            PeasyCam.this.dampedPanY.impulse(PeasyCam.this.panScale * d2 / 8.0);
        }
    };
    private final PeasyDragHandler rotateHandler;
    private PeasyDragHandler leftDragHandler = this.rotateHandler = new PeasyDragHandler(){

        public void handleDrag(double d, double d2) {
            if (PeasyCam.this.reverseRotate) {
                d2 *= -1.0;
                d *= -1.0;
            }
            PeasyCam.this.mouseRotate(d, d2);
        }
    };
    private final PeasyDragHandler zoomHandler;
    private PeasyDragHandler rightDraghandler = this.zoomHandler = new PeasyDragHandler(){

        public void handleDrag(double d, double d2) {
            if (PeasyCam.this.reverseZoom) {
                d2 *= -1.0;
            }
            PeasyCam.this.dampedZoom.impulse(PeasyCam.this.zoomScale * d2 / 10.0);
        }
    };
    private final PeasyWheelHandler zoomWheelHandler;
    private PeasyWheelHandler wheelHandler = this.zoomWheelHandler = new PeasyWheelHandler(){

        public void handleWheel(float f) {
            if (PeasyCam.this.reverseZoom) {
                f *= -1.0f;
            }
            PeasyCam.this.dampedZoom.impulse(PeasyCam.this.zoomScale * PeasyCam.this.wheelScale * (double)f);
        }
    };
    private double wheelScale = 1.0;
    private double zoomScale = 1.0;
    private double rotateScale = 1.0;
    private double panScale = 1.0;
    private final PeasyMouseListener mouseListener = new PeasyMouseListener();
    private boolean isActive = false;
    private final PMatrix3D originalMatrix;
    public static final String VERSION = "2.0.0+";

    public PeasyCam(PApplet pApplet, double d) {
        this(pApplet, 0.0, 0.0, 0.0, d);
    }

    public void setcam() {
        this.p.camera(70.0f, 35.0f, 120.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public PeasyCam(PApplet pApplet, double d, double d2, double d3, final double d4) {
        this.p = pApplet;
        this.panCenter = this.center = new Vector3D(d, d2, d3);
        this.startCenter = this.center;
        this.startDistance = this.distance = d4;
        this.rotation = new Rotation();
        this.originalMatrix = pApplet.getMatrix((PMatrix3D)null);
        this.andriod = System.getProperty("java.runtime.name").equalsIgnoreCase("android runtime");
        this.feed();
        this.rotateX = new DampedAction(this){

            protected void behave(double d) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusI, d));
            }
        };
        this.rotateY = new DampedAction(this){

            protected void behave(double d) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusJ, d));
            }
        };
        this.rotateZ = new DampedAction(this){

            protected void behave(double d) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusK, d));
            }
        };
        this.dampedZoom = new DampedAction(this){

            protected void behave(double d) {
                PeasyCam.this.mouseZoom(d);
            }
        };
        this.dampedPanX = new DampedAction(this){

            protected void behave(double d) {
                PeasyCam.this.mousePan(d, 0.0);
            }
        };
        this.dampedPanY = new DampedAction(this){

            protected void behave(double d) {
                PeasyCam.this.mousePan(0.0, d);
            }
        };
        this.p.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PeasyCam.this.setState(new CameraState(PeasyCam.this.rotation, PeasyCam.this.center, d4), 0L);
            }
        });
        this.setActive(true);
        System.out.println("PeasyCam v2.0.0+");
    }

    public void setDamping(double d, double d2, double d3) {
        this.rotateX.setDamping(Math.min(1.0, Math.max(0.0, d)));
        this.rotateY.setDamping(Math.min(1.0, Math.max(0.0, d)));
        this.rotateZ.setDamping(Math.min(1.0, Math.max(0.0, d)));
        this.dampedZoom.setDamping(Math.min(1.0, Math.max(0.0, d2)));
        this.dampedPanY.setDamping(Math.min(1.0, Math.max(0.0, d3)));
        this.dampedPanX.setDamping(Math.min(1.0, Math.max(0.0, d3)));
    }

    public void setSpeedLock(boolean bl) {
        this.rotateX.setSpeedLock(bl);
        this.rotateY.setSpeedLock(bl);
        this.rotateZ.setSpeedLock(bl);
        this.dampedZoom.setSpeedLock(bl);
        this.dampedPanY.setSpeedLock(bl);
        this.dampedPanX.setSpeedLock(bl);
    }

    public void setSpeedRate(double d) {
        this.rotateX.setSpeedRate(d);
        this.rotateY.setSpeedRate(d);
        this.rotateZ.setSpeedRate(d);
        this.dampedZoom.setSpeedRate(d);
        this.dampedPanY.setSpeedRate(d);
        this.dampedPanX.setSpeedRate(d);
    }

    public void setActive(boolean bl) {
        if (bl == this.isActive) {
            return;
        }
        this.isActive = bl;
        if (this.isActive) {
            this.p.registerMethod("mouseEvent", (Object)this.mouseListener);
            if (!this.andriod) {
                this.p.registerMethod("keyEvent", (Object)this.mouseListener);
            }
        } else {
            this.p.unregisterMethod("mouseEvent", (Object)this.mouseListener);
            if (!this.andriod) {
                this.p.unregisterMethod("keyEvent", (Object)this.mouseListener);
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setReverseZoom(boolean bl) {
        this.reverseZoom = bl;
    }

    public void setReverseRotate(boolean bl) {
        this.reverseRotate = bl;
    }

    public void setReversePan(boolean bl) {
        this.reversePan = bl;
    }

    public boolean isReversePan() {
        return this.reversePan;
    }

    public boolean isReverseZoom() {
        return this.reverseZoom;
    }

    public boolean isReverseRotate() {
        return this.reverseRotate;
    }

    @Deprecated
    public void setMouseControlled(boolean bl) {
        this.setActive(bl);
    }

    public double getWheelScale() {
        return this.wheelScale;
    }

    public void setWheelScale(double d) {
        this.wheelScale = d;
    }

    public PeasyDragHandler getPanDragHandler() {
        return this.panHandler;
    }

    public PeasyDragHandler getRotateDragHandler() {
        return this.rotateHandler;
    }

    public PeasyDragHandler getZoomDragHandler() {
        return this.zoomHandler;
    }

    public PeasyWheelHandler getZoomWheelHandler() {
        return this.zoomWheelHandler;
    }

    public PeasyDragHandler getLeftDragHandler() {
        return this.leftDragHandler;
    }

    public PeasyDragHandler getCenterDragHandler() {
        return this.centerDragHandler;
    }

    public PeasyDragHandler getRightDraghandler() {
        return this.rightDraghandler;
    }

    public void setLeftDragHandler(PeasyDragHandler peasyDragHandler) {
        this.leftDragHandler = peasyDragHandler;
    }

    public void setCenterDragHandler(PeasyDragHandler peasyDragHandler) {
        this.centerDragHandler = peasyDragHandler;
    }

    public void setRightDragHandler(PeasyDragHandler peasyDragHandler) {
        this.rightDraghandler = peasyDragHandler;
    }

    public PeasyWheelHandler getWheelHandler() {
        return this.wheelHandler;
    }

    public void setWheelHandler(PeasyWheelHandler peasyWheelHandler) {
        this.wheelHandler = peasyWheelHandler;
    }

    public double getZoomScale() {
        return this.zoomScale;
    }

    public void setZoomScale(double d) {
        this.zoomScale = d;
    }

    public double getPanScale() {
        return this.panScale;
    }

    public void setPanScale(double d) {
        this.panScale = d;
    }

    public double getRotationScale() {
        return this.rotateScale;
    }

    public void setRotationScale(double d) {
        this.rotateScale = d;
    }

    public String version() {
        return VERSION;
    }

    private void mouseZoom(double d) {
        this.safeSetDistance(this.distance + d * Math.log1p(this.distance));
    }

    private void mousePan(double d, double d2) {
        double d3 = Math.sqrt(this.distance * 0.005);
        this.pan(this.dragConstraint == Constraint.PITCH ? 0.0 : -d * d3, this.dragConstraint == Constraint.YAW ? 0.0 : -d2 * d3);
    }

    private void mouseRotate(double d, double d2) {
        Vector3D vector3D;
        double d3;
        Vector3D vector3D2 = LOOK.scalarMultiply(100.0 + 0.6 * this.startDistance).negate();
        int n = d > 0.0 ? -1 : 1;
        int n2 = d2 < 0.0 ? -1 : 1;
        double d4 = Math.abs((double)this.p.height / 2.0 - (double)this.p.mouseY) / ((double)this.p.height / 2.0);
        double d5 = Math.abs((double)this.p.width / 2.0 - (double)this.p.mouseX) / ((double)this.p.width / 2.0);
        if (this.dragConstraint == null || this.dragConstraint == Constraint.YAW || this.dragConstraint == Constraint.SUPPRESS_ROLL || this.dragConstraint == Constraint.SUPPRESS_PITCH) {
            d3 = Math.abs(d) * (1.0 - d4);
            vector3D = vector3D2.add(new Vector3D(d3, 0.0, 0.0));
            this.rotateY.impulse(Vector3D.angle(vector3D2, vector3D) * (double)n);
        }
        if (this.dragConstraint == null || this.dragConstraint == Constraint.PITCH || this.dragConstraint == Constraint.SUPPRESS_ROLL || this.dragConstraint == Constraint.SUPPRESS_YAW) {
            d3 = Math.abs(d2) * (1.0 - d5);
            vector3D = vector3D2.add(new Vector3D(0.0, d3, 0.0));
            this.rotateX.impulse(Vector3D.angle(vector3D2, vector3D) * (double)n2);
        }
        if (this.dragConstraint == null || this.dragConstraint == Constraint.ROLL || this.dragConstraint == Constraint.SUPPRESS_YAW || this.dragConstraint == Constraint.SUPPRESS_PITCH) {
            d3 = Math.abs(d2) * d5;
            vector3D = vector3D2.add(new Vector3D(0.0, d3, 0.0));
            this.rotateZ.impulse(Vector3D.angle(vector3D2, vector3D) * (double)(-n2) * (double)(this.p.mouseX < this.p.width / 2 ? -1 : 1));
            d3 = Math.abs(d) * d4;
            vector3D = vector3D2.add(new Vector3D(0.0, d3, 0.0));
            this.rotateZ.impulse(Vector3D.angle(vector3D2, vector3D) * (double)n * (double)(this.p.mouseY > this.p.height / 2 ? -1 : 1));
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        this.setDistance(d, 300L);
    }

    public void setDistance(double d, long l) {
        this.distanceInterps.startInterpolation(new DistanceInterp(d, l));
    }

    public float[] getLookAt() {
        return new float[]{(float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ()};
    }

    public void lookAt(double d, double d2, double d3) {
        this.centerInterps.startInterpolation(new CenterInterp(new Vector3D(d, d2, d3), 300L));
        this.panCenter = new Vector3D(d, d2, d3);
    }

    public void lookAt(double d, double d2, double d3, double d4) {
        this.lookAt(d, d2, d3);
        this.setDistance(d4);
    }

    public void lookAt(double d, double d2, double d3, long l) {
        this.lookAt(d, d2, d3, this.distance, l);
    }

    public void lookAt(double d, double d2, double d3, double d4, long l) {
        this.setState(new CameraState(this.rotation, new Vector3D(d, d2, d3), d4), l);
    }

    public void lookThrough(double d, double d2, double d3) {
        this.lookThrough(d, d2, d3, this.distance, 0L);
    }

    public void lookThrough(double d, double d2, double d3, double d4) {
        this.lookThrough(d, d2, d3, d4, 0L);
    }

    public void lookThrough(double d, double d2, double d3, long l) {
        this.lookThrough(d, d2, d3, this.distance, l);
    }

    public void lookThrough(double d, double d2, double d3, double d4, long l) {
        Vector3D vector3D = new Vector3D(d, d2, d3);
        Vector3D vector3D2 = new Vector3D(0.0, vector3D.getY(), vector3D.getZ());
        Vector3D vector3D3 = new Vector3D(1.0, 0.0, 0.0);
        Vector3D vector3D4 = Vector3D.crossProduct(vector3D3, vector3D2);
        vector3D3 = vector3D3.normalize();
        vector3D2 = vector3D2.normalize();
        vector3D4 = vector3D4.normalize();
        Vector3D vector3D5 = new Vector3D(Vector3D.dotProduct(vector3D3, vector3D), Vector3D.dotProduct(vector3D2, vector3D), Vector3D.dotProduct(vector3D4, vector3D));
        double d5 = Math.atan2(vector3D.getZ(), vector3D.getY()) - 1.5707963267948966;
        double d6 = Math.atan2(vector3D5.getX(), vector3D5.getY());
        this.setDistance(d4, l);
        this.setRotations(d5, d6, 0.0, l);
    }

    private void safeSetDistance(double d) {
        this.distance = Math.min(this.maximumDistance, Math.max(this.minimumDistance, d));
        this.feed();
    }

    private Vector3D safePanDistance(Vector3D vector3D) {
        double d = Vector3D.distance(vector3D, this.panCenter);
        if (d >= this.maximumPanDistance) {
            return this.center;
        }
        return vector3D;
    }

    public void feed() {
        Vector3D vector3D = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        Vector3D vector3D2 = this.rotation.applyTo(UP);
        this.p.camera((float)vector3D.getX(), (float)vector3D.getY(), (float)vector3D.getZ(), (float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ(), (float)vector3D2.getX(), (float)vector3D2.getY(), (float)vector3D2.getZ());
    }

    public static void apply(PGraphics pGraphics, Vector3D vector3D, Rotation rotation, double d) {
        Vector3D vector3D2 = rotation.applyTo(LOOK).scalarMultiply(d).add(vector3D);
        Vector3D vector3D3 = rotation.applyTo(UP);
        pGraphics.camera((float)vector3D2.getX(), (float)vector3D2.getY(), (float)vector3D2.getZ(), (float)vector3D.getX(), (float)vector3D.getY(), (float)vector3D.getZ(), (float)vector3D3.getX(), (float)vector3D3.getY(), (float)vector3D3.getZ());
    }

    public float[] getPosition() {
        Vector3D vector3D = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        return new float[]{(float)vector3D.getX(), (float)vector3D.getY(), (float)vector3D.getZ()};
    }

    public void reset() {
        this.reset(300L);
    }

    public void reset(long l) {
        this.setState(new CameraState(new Rotation(), this.startCenter, this.startDistance), l);
    }

    public void pan(double d, double d2) {
        this.center = this.safePanDistance(this.center.add(this.rotation.applyTo(new Vector3D(d, d2, 0.0))));
        this.feed();
    }

    public void rotateX(double d) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusI, d));
        this.feed();
    }

    public void rotateY(double d) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusJ, d));
        this.feed();
    }

    public void rotateZ(double d) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusK, d));
        this.feed();
    }

    PApplet getApplet() {
        return this.p;
    }

    public CameraState getState() {
        return new CameraState(this.rotation, this.center, this.distance);
    }

    public void setFreeRotationMode() {
        this.permaConstraint = null;
    }

    public void setYawRotationMode() {
        this.permaConstraint = Constraint.YAW;
    }

    public void setPitchRotationMode() {
        this.permaConstraint = Constraint.PITCH;
    }

    public void setRollRotationMode() {
        this.permaConstraint = Constraint.ROLL;
    }

    public void setSuppressRollRotationMode() {
        this.permaConstraint = Constraint.SUPPRESS_ROLL;
    }

    public void setSuppressYawRotationMode() {
        this.permaConstraint = Constraint.SUPPRESS_YAW;
    }

    public void setSuppressPitchRotationMode() {
        this.permaConstraint = Constraint.SUPPRESS_PITCH;
    }

    public double getMinimumDistance() {
        return this.minimumDistance;
    }

    public double getMaximumDistance() {
        return this.maximumDistance;
    }

    public void setMinimumDistance(double d) {
        this.minimumDistance = d;
        this.safeSetDistance(this.distance);
    }

    public void setMaximumDistance(double d) {
        this.maximumDistance = d;
        this.safeSetDistance(this.distance);
    }

    public void setMaximumPanDistance(double d) {
        this.maximumPanDistance = d;
    }

    public double getMaximumPanDistance() {
        return this.maximumPanDistance;
    }

    public void setResetOnDoubleClick(boolean bl) {
        this.resetOnDoubleClick = bl;
    }

    public void setPanOnScreenEdge(boolean bl) {
        if (bl && this.edgepan == null) {
            this.edgepan = new EdgeMonitor(this.p, this);
        } else if (!bl && this.edgepan != null) {
            this.edgepan.cancel();
            this.edgepan = null;
        }
    }

    public double getVelocity() {
        double[] dArray = new double[]{this.rotateX.getVelocity(), this.rotateY.getVelocity(), this.rotateZ.getVelocity(), this.dampedZoom.getVelocity(), this.dampedPanX.getVelocity(), this.dampedPanY.getVelocity()};
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public void stop() {
        this.rotateX.stop();
        this.rotateY.stop();
        this.rotateZ.stop();
        this.dampedPanX.stop();
        this.dampedPanY.stop();
        this.dampedZoom.stop();
        this.distanceInterps.cancelInterpolation();
        this.rotationInterps.cancelInterpolation();
        this.centerInterps.cancelInterpolation();
    }

    public boolean isMoving() {
        return this.rotateX.getVelocity() != 0.0 || this.rotateY.getVelocity() != 0.0 || this.rotateZ.getVelocity() != 0.0 || this.dampedZoom.getVelocity() != 0.0 || this.dampedPanX.getVelocity() != 0.0 || this.dampedPanY.getVelocity() != 0.0 || !this.distanceInterps.isStopped() || !this.centerInterps.isStopped() || !this.rotationInterps.isStopped();
    }

    public void setState(CameraState cameraState) {
        this.setState(cameraState, 300L);
    }

    public void setState(CameraState cameraState, long l) {
        if (l > 0L) {
            this.rotationInterps.startInterpolation(new RotationInterp(cameraState.rotation, l));
            this.centerInterps.startInterpolation(new CenterInterp(cameraState.center, l));
            this.distanceInterps.startInterpolation(new DistanceInterp(cameraState.distance, l));
        } else {
            this.rotation = cameraState.rotation;
            this.center = cameraState.center;
            this.distance = cameraState.distance;
        }
        this.feed();
    }

    public void setRotations(double d, double d2, double d3) {
        this.setRotations(d, d2, d3, 0L);
    }

    public void setRotations(double d, double d2, double d3, long l) {
        this.rotationInterps.cancelInterpolation();
        if (l > 0L) {
            this.rotationInterps.startInterpolation(new RotationInterp(new Rotation(RotationOrder.XYZ, d, d2, d3), l));
        } else {
            this.rotation = new Rotation(RotationOrder.XYZ, d, d2, d3);
        }
        this.feed();
    }

    public float[] getRotations() {
        try {
            double[] dArray = this.rotation.getAngles(RotationOrder.XYZ);
            return new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2]};
        }
        catch (CardanEulerSingularityException cardanEulerSingularityException) {
            try {
                double[] dArray = this.rotation.getAngles(RotationOrder.YXZ);
                return new float[]{(float)dArray[1], (float)dArray[0], (float)dArray[2]};
            }
            catch (CardanEulerSingularityException cardanEulerSingularityException2) {
                try {
                    double[] dArray = this.rotation.getAngles(RotationOrder.ZXY);
                    return new float[]{(float)dArray[2], (float)dArray[0], (float)dArray[1]};
                }
                catch (CardanEulerSingularityException cardanEulerSingularityException3) {
                    return new float[]{0.0f, 0.0f, 0.0f};
                }
            }
        }
    }

    public void beginHUD() {
        this.p.pushMatrix();
        this.p.hint(2);
        this.p.resetMatrix();
        this.p.applyMatrix(this.originalMatrix);
    }

    public void endHUD() {
        this.p.hint(-2);
        this.p.popMatrix();
    }

    public void setMouseOverSketch(boolean bl) {
        this.mouseIsOverSketch = bl;
    }

    public boolean isMouseOverSketch() {
        return this.mouseIsOverSketch;
    }

    public Point getMouseExit() {
        return this.mouseExit;
    }

    class RotationInterp
    extends AbstractInterp {
        final Rotation startRotation;
        final Rotation endRotation;

        public RotationInterp(Rotation rotation, long l) {
            super(l);
            this.startRotation = PeasyCam.this.rotation;
            this.endRotation = rotation;
        }

        void start() {
            PeasyCam.this.rotateX.stop();
            PeasyCam.this.rotateY.stop();
            PeasyCam.this.rotateZ.stop();
            super.start();
        }

        protected void interp(double d) {
            PeasyCam.this.rotation = InterpolationUtil.slerp(this.startRotation, this.endRotation, d);
        }

        protected void setEndState() {
            PeasyCam.this.rotation = this.endRotation;
        }
    }

    class CenterInterp
    extends AbstractInterp {
        private final Vector3D startCenter;
        private final Vector3D endCenter;

        public CenterInterp(Vector3D vector3D, long l) {
            super(l);
            this.startCenter = PeasyCam.this.center;
            this.endCenter = vector3D;
        }

        protected void interp(double d) {
            PeasyCam.this.center = InterpolationUtil.smooth(this.startCenter, this.endCenter, d);
        }

        protected void setEndState() {
            PeasyCam.this.center = this.endCenter;
        }
    }

    class DistanceInterp
    extends AbstractInterp {
        private final double startDistance;
        private final double endDistance;

        public DistanceInterp(double d, long l) {
            super(l);
            this.startDistance = PeasyCam.this.distance;
            this.endDistance = Math.min(PeasyCam.this.maximumDistance, Math.max(PeasyCam.this.minimumDistance, d));
        }

        protected void interp(double d) {
            PeasyCam.this.distance = InterpolationUtil.smooth(this.startDistance, this.endDistance, d);
        }

        protected void setEndState() {
            PeasyCam.this.distance = this.endDistance;
        }
    }

    public abstract class AbstractInterp {
        double startTime;
        final double timeInMillis;
        boolean stopped;

        protected AbstractInterp(long l) {
            this.timeInMillis = l;
            this.stopped = true;
        }

        void start() {
            this.startTime = PeasyCam.this.p.millis();
            PeasyCam.this.p.registerMethod("draw", (Object)this);
            this.stopped = false;
        }

        void cancel() {
            PeasyCam.this.p.unregisterMethod("draw", (Object)this);
            this.stopped = true;
        }

        boolean isStopped() {
            return this.stopped;
        }

        public void draw() {
            double d = ((double)PeasyCam.this.p.millis() - this.startTime) / this.timeInMillis;
            if (d > 0.99) {
                this.cancel();
                this.setEndState();
            } else {
                this.interp(d);
            }
            PeasyCam.this.feed();
        }

        protected abstract void interp(double var1);

        protected abstract void setEndState();
    }

    public class PeasyMouseListener {
        public void keyEvent(KeyEvent keyEvent) {
            if (keyEvent.getAction() == 2 && keyEvent.getKeyCode() == 1) {
                PeasyCam.this.dragConstraint = null;
            }
        }

        public void touchEvent(TouchEvent touchEvent) {
            if (touchEvent.getAction() == 0) {
                // empty if block
            }
        }

        public void mouseEvent(MouseEvent mouseEvent) {
            if (PeasyCam.this.resetOnDoubleClick && mouseEvent.getAction() == 3 && mouseEvent.getClickCount() == 2) {
                PeasyCam.this.reset();
            } else if (mouseEvent.getAction() == 2) {
                PeasyCam.this.dragConstraint = null;
            } else if (mouseEvent.getAction() == 4) {
                double d = ((PeasyCam)PeasyCam.this).p.mouseX - ((PeasyCam)PeasyCam.this).p.pmouseX;
                double d2 = ((PeasyCam)PeasyCam.this).p.mouseY - ((PeasyCam)PeasyCam.this).p.pmouseY;
                if (mouseEvent.isShiftDown()) {
                    if (PeasyCam.this.dragConstraint == null && Math.abs(d - d2) > 1.0) {
                        PeasyCam.this.dragConstraint = Math.abs(d) > Math.abs(d2) ? Constraint.YAW : Constraint.PITCH;
                    }
                } else if (PeasyCam.this.permaConstraint != null) {
                    PeasyCam.this.dragConstraint = PeasyCam.this.permaConstraint;
                } else {
                    PeasyCam.this.dragConstraint = null;
                }
                int n = ((PeasyCam)PeasyCam.this).p.mouseButton;
                if (PeasyCam.this.centerDragHandler != null && (n == 3 || n == 37 && mouseEvent.isMetaDown())) {
                    PeasyCam.this.centerDragHandler.handleDrag(d, d2);
                } else if (PeasyCam.this.leftDragHandler != null && n == 37) {
                    PeasyCam.this.leftDragHandler.handleDrag(d, d2);
                } else if (PeasyCam.this.rightDraghandler != null && n == 39) {
                    PeasyCam.this.rightDraghandler.handleDrag(d, d2);
                }
            } else if (mouseEvent.getAction() == 7) {
                PeasyCam.this.setMouseOverSketch(false);
                PeasyCam.this.mouseExit = new Point(mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getAction() == 6) {
                PeasyCam.this.setMouseOverSketch(true);
            } else if (mouseEvent.getAction() == 8) {
                PeasyCam.this.wheelHandler.handleWheel(mouseEvent.getAmount());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Constraint {
        YAW,
        PITCH,
        ROLL,
        SUPPRESS_ROLL,
        SUPPRESS_YAW,
        SUPPRESS_PITCH;

    }
}

