/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import java.awt.MouseInfo;
import java.awt.Point;
import peasy.PeasyCam;
import processing.core.PApplet;

public class EdgeMonitor {
    int left;
    int right;
    int top;
    int bottom;
    int xpos;
    int ypos;
    int ydelta;
    int xdelta;
    Point mouse;
    final PeasyCam cam;
    final PApplet p;
    boolean online;

    EdgeMonitor(PApplet p, PeasyCam cam) {
        this.p = p;
        this.cam = cam;
        try {
            p.getAppletContext();
            this.online = true;
        }
        catch (NullPointerException e) {
            this.online = false;
        }
        cam.setMouseOverSketch(true);
        p.registerMethod("draw", (Object)this);
    }

    void cancel() {
        this.p.unregisterMethod("draw", (Object)this);
    }

    public void draw() {
        if (!this.online) {
            if (this.p.frame.isFocused() || !this.p.frame.isVisible()) {
                this.mouse = MouseInfo.getPointerInfo().getLocation();
                if (this.p.frame.isVisible()) {
                    this.xpos = this.p.frame.getBounds().x;
                    this.ypos = this.p.frame.getBounds().y;
                    if (this.p.frame.isUndecorated()) {
                        this.ydelta = (this.p.frame.getBounds().height - this.p.height) / 2;
                        this.xdelta = (this.p.frame.getBounds().width - this.p.width) / 2;
                    } else {
                        this.ydelta = this.p.frame.getBounds().height - this.p.height;
                        this.xdelta = this.p.frame.getBounds().width - this.p.width;
                    }
                } else {
                    this.xpos = 0;
                    this.ypos = 0;
                    this.ydelta = 0;
                    this.xdelta = 0;
                }
                this.left = this.xpos + this.xdelta;
                this.top = this.ypos + this.ydelta;
                this.right = this.left + this.p.width - 1;
                this.bottom = this.top + this.p.height - 1;
                if (this.mouse.x <= this.left || this.mouse.x >= this.right || this.mouse.y <= this.top || this.mouse.y >= this.bottom) {
                    double dx = 0.0;
                    double dy = 0.0;
                    if (this.mouse.x <= this.left) {
                        dx = -8.0;
                    } else if (this.mouse.x >= this.right) {
                        dx = 8.0;
                    }
                    if (this.mouse.y <= this.top) {
                        dy = -8.0;
                    } else if (this.mouse.y >= this.bottom) {
                        dy = 8.0;
                    }
                    this.cam.getPanDragHandler().handleDrag(dx, dy);
                }
            }
        } else if (!this.cam.isMouseOverSketch()) {
            double dx = 0.0;
            double dy = 0.0;
            if (this.cam.getMouseExit().x <= 1) {
                dx = -8.0;
            } else if (this.cam.getMouseExit().x >= this.p.width - 1) {
                dx = 8.0;
            }
            if (this.cam.getMouseExit().y <= 1) {
                dy = -8.0;
            } else if (this.cam.getMouseExit().y >= this.p.height - 1) {
                dy = 8.0;
            }
            this.cam.getPanDragHandler().handleDrag(dx, dy);
        }
    }
}

