/*
 * Decompiled with CFR 0.152.
 */
import peasy.PeasyCam;
import processing.core.PApplet;
import processing.core.PVector;

public class HangingNet
extends PApplet {
    int NUM_NODES = 11;
    float SlackFactor = 1.0f;
    PVector Gravity = new PVector(0.0f, 0.0f, -0.98f);
    float DampingFactor = 0.9f;
    PeasyCam cam;
    Node[] arrayNodes;
    Line[] arrayLines;

    public void setup() {
        this.size(800, 800, "processing.opengl.PGraphics3D");
        this.cam = new PeasyCam((PApplet)this, (double)(this.width / 2), (double)(this.height / 2), -200.0, 1000.0);
        this.cam.setRotations(-1.5707963705062866, 0.0, 0.0);
        float f = 0.25f;
        this.arrayNodes = new Node[this.NUM_NODES * this.NUM_NODES];
        int n = 0;
        while (n < this.NUM_NODES) {
            int n2 = 0;
            while (n2 < this.NUM_NODES) {
                this.arrayNodes[n * this.NUM_NODES + n2] = new Node((float)this.width * f + (1.0f - 2.0f * f) * (float)n * (float)this.width / (float)(this.NUM_NODES - 1), (float)this.height * f + (1.0f - 2.0f * f) * (float)n2 * (float)this.height / (float)(this.NUM_NODES - 1), 0.0f, false, false, false);
                ++n2;
            }
            ++n;
        }
        this.arrayNodes[0].Fix();
        this.arrayNodes[this.NUM_NODES - 1].Fix();
        this.arrayNodes[(this.NUM_NODES - 1) * this.NUM_NODES].Fix();
        this.arrayNodes[this.NUM_NODES * this.NUM_NODES - 1].Fix();
        int n3 = 0;
        this.arrayLines = new Line[2 * this.NUM_NODES * (this.NUM_NODES - 1)];
        int n4 = 0;
        while (n4 < this.NUM_NODES) {
            int n5 = 0;
            while (n5 < this.NUM_NODES) {
                Node node;
                Node node2;
                if (n4 < this.NUM_NODES - 1) {
                    node2 = this.arrayNodes[n4 * this.NUM_NODES + n5];
                    node = this.arrayNodes[(n4 + 1) * this.NUM_NODES + n5];
                    this.arrayLines[n3++] = new Line(node2, node);
                }
                if (n5 < this.NUM_NODES - 1) {
                    node2 = this.arrayNodes[n4 * this.NUM_NODES + n5];
                    node = this.arrayNodes[n4 * this.NUM_NODES + n5 + 1];
                    this.arrayLines[n3++] = new Line(node2, node);
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void draw() {
        this.background(0.0f, 0.0f, 0.0f);
        float f = 10.0f;
        if (this.keyPressed && this.key == '\uffff') {
            switch (this.keyCode) {
                case 38: {
                    Node node = this.arrayNodes[this.NUM_NODES - 1];
                    node.Coord.z += f;
                    break;
                }
                case 40: {
                    Node node = this.arrayNodes[this.NUM_NODES - 1];
                    node.Coord.z -= f;
                    break;
                }
                case 37: {
                    Node node = this.arrayNodes[this.NUM_NODES - 1];
                    node.Coord.x -= f;
                    break;
                }
                case 39: {
                    Node node = this.arrayNodes[this.NUM_NODES - 1];
                    node.Coord.x += f;
                    break;
                }
                case 17: {
                    if (!this.mousePressed) break;
                    Node node = this.mouseButton == 37 ? this.arrayNodes[0] : this.arrayNodes[this.NUM_NODES - 1];
                    node.Coord.x = this.mouseX;
                    node.Coord.z = this.height / 2 - this.mouseY;
                }
            }
        }
        this.UpdateCoords(1.0f);
        this.DrawLines();
        this.DrawNodes();
    }

    public void keyPressed() {
        if (this.key == ' ') {
            this.setup();
        }
    }

    public void UpdateCoords(float f) {
        PVector pVector = PVector.mult((PVector)this.Gravity, (float)f);
        int n = 0;
        while (n < this.arrayLines.length) {
            Line line = this.arrayLines[n];
            float f2 = line.GetLength();
            float f3 = 10.0f * (f2 - line.SlackLength) / line.SlackLength;
            PVector pVector2 = PVector.sub((PVector)line.NodeEnd.Coord, (PVector)line.NodeStart.Coord);
            pVector2.setMag(0.5f * f3);
            line.NodeStart.Force.add(pVector2);
            line.NodeEnd.Force.sub(pVector2);
            ++n;
        }
        n = 0;
        while (n < this.arrayNodes.length) {
            Node node = this.arrayNodes[n];
            node.Velocity.add(PVector.mult((PVector)node.Force, (float)f));
            node.Velocity.add(pVector);
            if (node.XFixed) {
                node.Velocity.x = 0.0f;
            }
            if (node.YFixed) {
                node.Velocity.y = 0.0f;
            }
            if (node.ZFixed) {
                node.Velocity.z = 0.0f;
            }
            node.Coord.add(PVector.mult((PVector)node.Velocity, (float)f));
            node.Force = new PVector();
            node.Velocity.mult(this.DampingFactor);
            ++n;
        }
    }

    public void DrawNodes() {
        this.strokeWeight(10.0f);
        this.beginShape(3);
        int n = 0;
        while (n < this.arrayNodes.length) {
            Node node = this.arrayNodes[n];
            this.stroke(128 + 128 * PApplet.parseInt((boolean)node.XFixed), 128 + 128 * PApplet.parseInt((boolean)node.YFixed), 128 + 128 * PApplet.parseInt((boolean)node.ZFixed));
            this.vertex(node.Coord.x, node.Coord.y, node.Coord.z);
            ++n;
        }
        this.endShape();
    }

    public void DrawLines() {
        this.stroke(255.0f, 255.0f, 255.0f);
        this.strokeWeight(2.0f);
        this.beginShape(5);
        int n = 0;
        while (n < this.arrayLines.length) {
            Line line = this.arrayLines[n];
            this.vertex(line.NodeStart.Coord.x, line.NodeStart.Coord.y, line.NodeStart.Coord.z);
            this.vertex(line.NodeEnd.Coord.x, line.NodeEnd.Coord.y, line.NodeEnd.Coord.z);
            ++n;
        }
        this.endShape();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"HangingNet"};
        if (stringArray != null) {
            PApplet.main((String[])HangingNet.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Line {
        Node NodeStart;
        Node NodeEnd;
        float SlackLength;

        Line(Node node, Node node2) {
            this.NodeStart = node;
            this.NodeEnd = node2;
            this.SlackLength = this.GetLength();
            this.SlackLength *= HangingNet.this.SlackFactor;
        }

        public float GetLength() {
            return PVector.sub((PVector)this.NodeEnd.Coord, (PVector)this.NodeStart.Coord).mag();
        }
    }

    class Node {
        PVector Coord;
        PVector Force;
        PVector Velocity;
        boolean XFixed;
        boolean YFixed;
        boolean ZFixed;

        Node(float f, float f2, float f3, boolean bl, boolean bl2, boolean bl3) {
            this.Coord = new PVector(f, f2, f3);
            this.Force = new PVector();
            this.Velocity = new PVector();
            this.XFixed = bl;
            this.YFixed = bl2;
            this.ZFixed = bl3;
        }

        public void Fix() {
            this.ZFixed = true;
            this.YFixed = true;
            this.XFixed = true;
        }
    }
}

