int NUM_NODES = 11;
float SlackFactor = 1.0;
float Gravity = 0.98;
float DampingFactor = 0.9;

class Node
{
    float XCoord, YCoord;
    boolean XFixed, YFixed;
    float XForce, YForce, XVelocity, YVelocity;

    Node (float x, float y, boolean xfix, boolean yfix)
    {
        XCoord = x;
        YCoord = y;
        XFixed = xfix;
        YFixed = yfix;
        XForce = 0.0;
        YForce = 0.0;
        XVelocity = 0.0;
        YVelocity = 0.0;
    }
}

class Line
{
    Node NodeStart, NodeEnd;
    float SlackLength;

    Line (Node start, Node end)
    {
        NodeStart = start;
        NodeEnd = end;
        SlackLength = GetLength();
        SlackLength *= SlackFactor;
    }
    
    float GetLength()
    {
        return sqrt((NodeEnd.XCoord-NodeStart.XCoord)*(NodeEnd.XCoord-NodeStart.XCoord) + (NodeEnd.YCoord-NodeStart.YCoord)*(NodeEnd.YCoord-NodeStart.YCoord));
    }
}

Node[] arrayNodes;
Line[] arrayLines;

void setup() 
{ 
    size(800, 800);
    int y_pos = height/4;
    
    arrayNodes = new Node[NUM_NODES];
    arrayNodes[0] = new Node(width/8, y_pos, true, true);
    for (int count=1; count<NUM_NODES-1; count++)
    {
        arrayNodes[count] = new Node(width/8+0.75*count*width/(NUM_NODES-1), y_pos, false, false);
    }
    arrayNodes[NUM_NODES-1] = new Node(7*width/8, y_pos, true, true);
    
    Node startNode, endNode;
    arrayLines = new Line[NUM_NODES-1];
    endNode = arrayNodes[0];
    for (int count=1; count<NUM_NODES; count++)
    {
        startNode = endNode;
        endNode = arrayNodes[count];
        arrayLines[count-1] = new Line(startNode, endNode);
    }
} 

void draw() 
{ 
    background(0.0, 0.0, 0.0);
    //lights();
    
    if (mousePressed)
    {
        Node aNode;
        if (mouseButton==LEFT)
        {
            aNode = arrayNodes[0];
        }
        else 
        {
            aNode = arrayNodes[NUM_NODES-1];
        }
        aNode.XCoord = mouseX;
        aNode.YCoord = mouseY;
    }
    
    UpdateCoords(1.0);

    DrawLines();
    DrawNodes();
} 

void UpdateCoords(float time_step)
{
    Node aNode;
    Line aLine;
    float force, linelength, xlength, ylength;
    
    for (int count=0; count<NUM_NODES-1; count++)
    {
        aLine = arrayLines[count];
        linelength = aLine.GetLength();
        force = 10.0*(linelength-aLine.SlackLength)/aLine.SlackLength;
        xlength = aLine.NodeEnd.XCoord-aLine.NodeStart.XCoord;
        ylength = aLine.NodeEnd.YCoord-aLine.NodeStart.YCoord;
        
        aLine.NodeStart.XForce += 0.5 * force * xlength/linelength;
        aLine.NodeStart.YForce += 0.5 * force * ylength/linelength;
        aLine.NodeEnd.XForce -= 0.5 * force * xlength/linelength;
        aLine.NodeEnd.YForce -= 0.5 * force * ylength/linelength;
    }

    for (int count=0; count<NUM_NODES; count++)
    {
        aNode = arrayNodes[count];
        aNode.XVelocity += aNode.XForce * time_step;
        aNode.YVelocity += aNode.YForce * time_step;
        aNode.YVelocity += Gravity * time_step;  //  Gravity
        if (aNode.XFixed) aNode.XVelocity = 0.0;
        if (aNode.YFixed) aNode.YVelocity = 0.0;
        aNode.XCoord += aNode.XVelocity * time_step;
        aNode.YCoord += aNode.YVelocity * time_step;
        aNode.XForce = 0.0;
        aNode.YForce = 0.0;  //  ready for next time
        aNode.XVelocity *= DampingFactor;
        aNode.YVelocity *= DampingFactor;  //  ready for next time
    }

}

void DrawNodes()
{
    Node aNode;

    strokeWeight(10);
    //smooth();
    beginShape(POINTS);
    for (int count=0; count<NUM_NODES; count++)
    {
        aNode = arrayNodes[count];
        stroke(255*int(aNode.XFixed), 255*int(aNode.YFixed), 255);  //  White
        vertex(aNode.XCoord, aNode.YCoord);
    }
    endShape();
    //noSmooth();
}

void DrawLines()
{
    Line aLine;

    stroke(255, 255, 255);  //  White
    strokeWeight(2);
    beginShape(LINES);
    for (int count=0; count<NUM_NODES-1; count++)
    {
        aLine = arrayLines[count];
        vertex(aLine.NodeStart.XCoord, aLine.NodeStart.YCoord);
        vertex(aLine.NodeEnd.XCoord, aLine.NodeEnd.YCoord);
    }
    endShape();
}



