/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;

public class HangingChain
extends PApplet {
    int NUM_NODES = 11;
    float SlackFactor = 0.5f;
    float Gravity = 0.0098f;
    float DampingFactor = 0.95f;
    float MassFactor = 1.0f;
    float EA = 200.0f;
    boolean ParabolaInstead = false;
    boolean GravityOn = false;
    Node[] arrayNodes;
    Line[] arrayLines;

    public void setup() {
        this.size(800, 800);
        int n = this.height / 4;
        this.arrayNodes = new Node[this.NUM_NODES];
        this.arrayNodes[0] = new Node(this.width / 8, n, true, true);
        int n2 = 1;
        while (n2 < this.NUM_NODES - 1) {
            this.arrayNodes[n2] = new Node((float)(this.width / 8) + 0.75f * (float)n2 * (float)this.width / (float)(this.NUM_NODES - 1), n, false, false);
            ++n2;
        }
        this.arrayNodes[this.NUM_NODES - 1] = new Node(7 * this.width / 8, n, true, true);
        this.arrayLines = new Line[this.NUM_NODES - 1];
        Node node = this.arrayNodes[0];
        int n3 = 1;
        while (n3 < this.NUM_NODES) {
            Node node2 = node;
            node = this.arrayNodes[n3];
            this.arrayLines[n3 - 1] = new Line(node2, node);
            ++n3;
        }
    }

    public void draw() {
        this.background(0.0f, 0.0f, 0.0f);
        if (this.mousePressed) {
            Node node = this.mouseButton == 37 ? this.arrayNodes[0] : this.arrayNodes[this.NUM_NODES - 1];
            node.XCoord = this.mouseX;
            node.YCoord = this.mouseY;
        }
        this.UpdateCoords(1.0f);
        this.DrawLines();
        this.DrawNodes();
    }

    public void UpdateCoords(float f) {
        int n = 0;
        while (n < this.NUM_NODES - 1) {
            Line line = this.arrayLines[n];
            float f2 = line.GetLength();
            float f3 = this.EA * (f2 - line.SlackLength) / line.SlackLength;
            float f4 = line.NodeEnd.XCoord - line.NodeStart.XCoord;
            float f5 = line.NodeEnd.YCoord - line.NodeStart.YCoord;
            line.NodeStart.XForce += 0.5f * f3 * f4 / f2;
            line.NodeStart.YForce += 0.5f * f3 * f5 / f2;
            line.NodeEnd.XForce -= 0.5f * f3 * f4 / f2;
            line.NodeEnd.YForce -= 0.5f * f3 * f5 / f2;
            if (this.ParabolaInstead) {
                line.NodeStart.Mass += 0.5f * HangingChain.abs((float)f4) * this.MassFactor;
                line.NodeEnd.Mass += 0.5f * HangingChain.abs((float)f4) * this.MassFactor;
            } else {
                line.NodeStart.Mass += 0.5f * f2 * this.MassFactor;
                line.NodeEnd.Mass += 0.5f * f2 * this.MassFactor;
            }
            ++n;
        }
        n = 0;
        while (n < this.NUM_NODES) {
            Node node = this.arrayNodes[n];
            node.XVelocity += node.XForce * f / node.Mass;
            node.YVelocity += node.YForce * f / node.Mass;
            if (this.GravityOn) {
                node.YVelocity += this.Gravity * node.Mass * f;
            }
            if (node.XFixed) {
                node.XVelocity = 0.0f;
            }
            if (node.YFixed) {
                node.YVelocity = 0.0f;
            }
            node.XCoord += node.XVelocity * f;
            node.YCoord += node.YVelocity * f;
            node.XForce = 0.0f;
            node.YForce = 0.0f;
            node.XVelocity *= this.DampingFactor;
            node.YVelocity *= this.DampingFactor;
            node.Radius = node.Mass * this.MassFactor / 2.0f;
            node.Mass = 0.0f;
            ++n;
        }
    }

    public void DrawNodes() {
        this.beginShape(3);
        int n = 0;
        while (n < this.NUM_NODES) {
            Node node = this.arrayNodes[n];
            if (node.XFixed || node.YFixed) {
                this.strokeWeight(node.Radius * 2.0f);
                this.stroke(196 * PApplet.parseInt((boolean)node.XFixed), 196 * PApplet.parseInt((boolean)node.YFixed), 196.0f);
            } else {
                this.strokeWeight(node.Radius);
                this.stroke(64.0f, 64.0f, 255.0f);
            }
            this.vertex(node.XCoord, node.YCoord);
            ++n;
        }
        this.endShape();
    }

    public void DrawLines() {
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(4.0f);
        this.beginShape(5);
        int n = 0;
        while (n < this.NUM_NODES - 1) {
            Line line = this.arrayLines[n];
            this.vertex(line.NodeStart.XCoord, line.NodeStart.YCoord);
            this.vertex(line.NodeEnd.XCoord, line.NodeEnd.YCoord);
            ++n;
        }
        this.endShape();
    }

    public void keyPressed() {
        block0 : switch (this.key) {
            case ' ': {
                this.GravityOn = !this.GravityOn;
                break;
            }
            case '\n': {
                this.ParabolaInstead = !this.ParabolaInstead;
                break;
            }
            case '\uffff': {
                switch (this.keyCode) {
                    case 34: {
                        this.GravityOn = !this.GravityOn;
                        break block0;
                    }
                    case 33: {
                        this.ParabolaInstead = !this.ParabolaInstead;
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"HangingChain"};
        if (stringArray != null) {
            PApplet.main((String[])HangingChain.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Line {
        Node NodeStart;
        Node NodeEnd;
        float SlackLength;

        Line(Node node, Node node2) {
            this.NodeStart = node;
            this.NodeEnd = node2;
            this.SlackLength = this.GetLength() * HangingChain.this.SlackFactor;
        }

        public float GetLength() {
            return HangingChain.sqrt((float)((this.NodeEnd.XCoord - this.NodeStart.XCoord) * (this.NodeEnd.XCoord - this.NodeStart.XCoord) + (this.NodeEnd.YCoord - this.NodeStart.YCoord) * (this.NodeEnd.YCoord - this.NodeStart.YCoord)));
        }
    }

    class Node {
        float XCoord;
        float YCoord;
        boolean XFixed;
        boolean YFixed;
        float XForce;
        float YForce;
        float XVelocity;
        float YVelocity;
        float Mass;
        float Radius;

        Node(float f, float f2, boolean bl, boolean bl2) {
            this.XCoord = f;
            this.YCoord = f2;
            this.XFixed = bl;
            this.YFixed = bl2;
            this.XForce = 0.0f;
            this.YForce = 0.0f;
            this.XVelocity = 0.0f;
            this.YVelocity = 0.0f;
            this.Mass = 0.0f;
            this.Radius = 10.0f;
        }
    }
}

