% Do not edit. This function is used to plot the country boundaries 
% along with the classification predictions given by the model.
function plotBoundaries(mdl,data)
    % load citydata.mat cities cborders
    % Make a grid of predictor points
    % [x,y] = meshgrid(linspace(2,8),linspace(48,54));

    aux1=[min(data{:,3}),max(data{:,3})];
    aux1(1)=aux1(1)-diff(aux1)*0.1; aux1(2)=aux1(2)+diff(aux1)*0.1;

    aux2=[min(data{:,2}),max(data{:,2})];
    aux2(1)=aux2(1)-diff(aux2)*0.1; aux2(2)=aux2(2)+diff(aux2)*0.1;


    [x,y] = meshgrid(linspace(aux1(1),aux1(2)),linspace(aux2(1),aux2(2)));
    % Apply the model
    mdlpreds = predict(mdl,[y(:),x(:)]);
    % Visualize results
    % var1=cities.Properties.VariableNames{2};
    % var2=cities.Properties.VariableNames{3};
    % output=cities.Properties.VariableNames{1};

    gscatter(data{:,3},data{:,2},data{:,1},[],[],[],false);
    hold on
    %plot(cborders,FaceColor="none")

    if isa(mdlpreds,'cell')
        mdlpreds0=mdlpreds;
        mdlpreds=categorical(mdlpreds0(1));
            for i=2:numel(mdlpreds0)
                mdlpreds=[mdlpreds;categorical(mdlpreds0(i))];
            end
    end    
    
    pc = pcolor(x,y,reshape(mdlpreds,size(x)));



    pc.FaceAlpha = 0.2;
    pc.LineStyle = "none";
    c = colororder;
    colormap(c(1:length(unique(data{:,1})),:))
    hold off
    % axis equal
    % axis([2 8 48 54])
    % legend(categories(cities{:,1}),Location="eastoutside")
end