// DecimalDisplayTwoDigit
// 
// C.T.Clarke
//
// October 2017
//
// A two digit Decimal display decoder. Note that the output is blanked if the input
// is out of range (>99)

module DecimalDisplayTwoDigit 
#(
	parameter		ActiveValue = 0		// The output value that switches an LED on.
)
(
	input 	[6:0]	Value, 					// The input value in the decimal range 0-F
	output 	[6:0]	Segments1,Segments0  // The 7 bit outputs for the 7 segment displays.
);

	wire 	[6:0]	Digit [1:0];
	wire 			Blank [1:0];

	// Separate the digits
	assign Digit[0] = Value % 4'd10;
	assign Digit[1] = Value / 4'd10;

	// Set the blanking conditions
	assign Blank[0] = (Value > 7'd99) ? 1'b1 : 1'b0;
	assign Blank[1] = (Digit[1] == 7'd0) ? 1'b1 : Blank[0];

	// Instantiate the LED decoders
	SevenSegmentDecoder #(ActiveValue) decoder0 (Digit[0][3:0],Blank[0],Segments0);
	SevenSegmentDecoder #(ActiveValue) decoder1 (Digit[1][3:0],Blank[1],Segments1);

endmodule
