/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.PrintWriter;
import java.util.HashMap;
import processing.core.PApplet;
import processing.data.Sort;

public class StringHash {
    public int count;
    protected String[] keys;
    protected String[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public StringHash() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new String[10];
    }

    public StringHash(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new String[length];
    }

    public StringHash(PApplet parent, String filename) {
        String[] lines = parent.loadStrings(filename);
        this.keys = new String[lines.length];
        this.values = new String[lines.length];
        int i = 0;
        while (i < lines.length) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length == 2) {
                this.create(pieces[0], pieces[1]);
            }
            ++i;
        }
    }

    public void write(PApplet parent, String filename) {
        PrintWriter writer = parent.createWriter(filename);
        boolean csv = filename.toLowerCase().endsWith(".csv") || filename.toLowerCase().endsWith(".csv.gz");
        int i = 0;
        while (i < this.count) {
            if (!csv) {
                writer.println(String.valueOf(this.key(i)) + "\t" + this.value(i));
            }
            ++i;
        }
    }

    public int getCount() {
        return this.count;
    }

    public String key(int index) {
        return this.keys[index];
    }

    public void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public String[] keys() {
        this.crop();
        return this.keys;
    }

    public String[] keyArray() {
        String[] outgoing = new String[this.count];
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public String value(int index) {
        return this.values[index];
    }

    public String[] values() {
        this.crop();
        return this.values;
    }

    public String[] valueArray() {
        String[] outgoing = new String[this.count];
        System.arraycopy(this.values, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public String get(String what) {
        int index = this.keyIndex(what);
        if (index == -1) {
            return null;
        }
        return this.values[index];
    }

    public void set(String key, String val) {
        int index = this.keyIndex(key);
        if (index == -1) {
            this.create(key, val);
        } else {
            this.values[index] = val;
        }
    }

    public void append(String key, String val) {
        int index = this.keyIndex(key);
        if (index == -1) {
            this.create(key, val);
        } else {
            int n = index;
            this.values[n] = String.valueOf(this.values[n]) + val;
        }
    }

    public int keyIndex(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    public int valueIndex(String what) {
        int i = 0;
        while (i < this.count) {
            if (this.values[i].equals(what)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void create(String k, String v) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(k, new Integer(this.count));
        this.keys[this.count] = k;
        this.values[this.count] = v;
        ++this.count;
    }

    public void print() {
        this.write(new PrintWriter(System.out));
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(String.valueOf(this.keys[i]) + "\t" + this.values[i]);
            ++i;
        }
        writer.flush();
    }

    public void remove(String which) {
        this.remove(this.keyIndex(which));
    }

    public void remove(int which) {
        this.indices.remove(this.keys[which]);
        int i = which;
        while (i < this.count - 1) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
            ++i;
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = null;
    }

    public void swap(int a, int b) {
        String tkey = this.keys[a];
        String tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
        this.indices.put(this.keys[a], new Integer(a));
        this.indices.put(this.keys[b], new Integer(b));
    }

    public void sortKeys() {
        Sort s = new Sort(){

            @Override
            public int size() {
                return StringHash.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int result = StringHash.this.keys[a].compareToIgnoreCase(StringHash.this.keys[b]);
                if (result != 0) {
                    return result;
                }
                return StringHash.this.values[a].compareToIgnoreCase(StringHash.this.values[b]);
            }

            @Override
            public void swap(int a, int b) {
                StringHash.this.swap(a, b);
            }
        };
        s.run();
    }

    public void sortValues() {
        this.sortValues(true, true);
    }

    public void sortValues(boolean descending) {
        this.sortValues(descending, true);
    }

    public void sortValues(final boolean descending, final boolean tiebreaker) {
        Sort s = new Sort(){

            @Override
            public int size() {
                return StringHash.this.count;
            }

            @Override
            public float compare(int a, int b) {
                float diff = StringHash.this.values[a].compareToIgnoreCase(StringHash.this.values[b]);
                if (tiebreaker && diff == 0.0f) {
                    diff = StringHash.this.keys[a].compareToIgnoreCase(StringHash.this.keys[b]);
                }
                return descending ? diff : -diff;
            }

            @Override
            public void swap(int a, int b) {
                StringHash.this.swap(a, b);
            }
        };
        s.run();
    }
}

