int sourcearray[][];
int currentarray[][];
PImage sourceimg;
float noise = 0.1;
int xpixel;
int ypixel;
float J=10;
float H=1;
float sumcalc;
float probchange;
int notrials = 3000;
int stopper=1;

void setup() {
  size(600,600);
  background(255);
  sourceimg = loadImage("apts.jpg");
  sourcearray = new int[width+1][height+1];
  currentarray = new int[width+1][height+1];
  
  loadPixels();
  for( int i=0 ; i<=width-1 ; i++ ) {
    for( int j=0 ; j<=height-1 ; j++ ) {
      if(red(sourceimg.pixels[i+width*j])<128) { sourcearray[i][j] = 1; } else { sourcearray[i][j] = -1; }
      if( random(1) < noise ) { sourcearray[i][j] = (-1)*sourcearray[i][j]; }
      currentarray[i][j] = sourcearray[i][j];
      pixels[i+width*j] = color(127-127*currentarray[i][j]);
    }
  }
  updatePixels();
  noLoop();
}

void draw() {
  loadPixels();
  for( int i=1 ; i<=notrials ; i++ ) {
    xpixel = floor(random(width));
    ypixel = floor(random(height));
    sumcalc=0;
    sumcalc += J*currentarray[xpixel][ypixel]*currentarray[(xpixel+1)%width][ypixel];
    sumcalc += J*currentarray[xpixel][ypixel]*currentarray[xpixel][(ypixel+1)%height];
    sumcalc += J*currentarray[xpixel][ypixel]*currentarray[(xpixel-1+width)%width][ypixel];
    sumcalc += J*currentarray[xpixel][ypixel]*currentarray[xpixel][(ypixel-1+height)%height];
    sumcalc += H*currentarray[xpixel][ypixel]*sourcearray[xpixel][ypixel];
    probchange = exp(-sumcalc)/(exp(-sumcalc) + exp(sumcalc));
    
    if( random(1) < probchange ) { currentarray[xpixel][ypixel] = (-1)*currentarray[xpixel][ypixel]; println("(" + xpixel + ", " + ypixel + ")" ); }
    pixels[xpixel + width*ypixel] = color(127-127*currentarray[xpixel][ypixel]);
  }
  updatePixels();
}

void keyReleased() {
  if (stopper == 1) { loop(); stopper = 0; } else { noLoop(); stopper = 1; }
}
