//Runs heat bath dynamics for the Ising model, starting from the left half the lattice in state +1 and the right half in state -1. Press a key to start.

int latticesize;
float spacing;
int[][] colour;
float elrad;
float randomno;
int x1, y1, x2, y2, x3, y3, x4, y4;
float beta;
float prob;
float proportion;
int stopper = 1;

void setup() {
  
  size(900, 900);
  background(255);
  
  beta = 0.5*log(1+sqrt(2));
  latticesize=50;
  colour = new int[latticesize+5][latticesize+5];
  
  spacing = (height-100)/(float)latticesize;
  elrad = spacing;
  
  for( int i=1 ; i<=latticesize ; i++ ) {
    for( int j=1 ; j<=latticesize ; j++ ) {
      if( i<=latticesize/2 ) { colour[i][j] = 1; fill(255,0,0); proportion += 1/(float)(latticesize*latticesize); } else { colour[i][j] = -1; fill(0,0,255); }
      ellipse(50+(i-0.5)*spacing, 50+(j-0.5)*spacing, elrad, elrad);
    }
  }
  
  strokeWeight(0.5);
  noLoop();
}

void draw()
{
  
  swap();
  
}

void swap()
{
  
  x1 = ceil(random(latticesize));
  y1 = ceil(random(latticesize));
  
  if( colour[x1][y1]==1 ) { proportion -= 1/(float)(latticesize*latticesize); }
  
  randomno = random(1);
  
  prob = 1/(1+exp(-beta*(colour[x1+1][y1]+colour[x1-1][y1]+colour[x1][y1+1]+colour[x1][y1-1])));
  
  if( randomno < prob ) {
    colour[x1][y1] = 1;
    fill(255,0,0);
    proportion += 1/(float)(latticesize*latticesize);
  } else {
    colour[x1][y1] = -1;
    fill(0,0,255);
  }
  
  ellipse(50+(x1-0.5)*spacing, 50+(y1-0.5)*spacing, elrad, elrad);
  
}

void keyReleased() {
  if (stopper == 1) { loop(); stopper = 0; } else { noLoop(); stopper = 1; }
}
