# -*- coding: utf-8 -*-
from Tkinter import *
from tkFileDialog import asksaveasfilename

from UserList import UserList

class Controls(UserList,Frame):
    def __init__(self,master,actionlist):
        UserList.__init__(self)
        Frame.__init__(self,master,borderwidth=4,relief=GROOVE)

        self.append(Button(master,text="QUIT",fg="red",command=master.destroy))
        for a in actionlist:
            if len(a)==2:
                # TEXT, COMMAND
                self.append(Button(master,text=a[0],command=a[1]))

            elif len(a)==4:
                # OFFTEXT, ONTEXT, TEXTVAR, COMMAND
                a[2].set(a[0])
                self.append(Checkbutton(master,textvariable=a[2],
                                        offvalue=a[0],onvalue=a[1],
                                        indicatoron=FALSE,
                                        width=max(len(a[0]),len(a[1])),
                                        variable=a[2],
                                        command=a[3]))
            else:
                raise "Controls: unknown specification"
        i=0
        for b in self:
            b.grid(column=3, row=i, sticky=E+W+N+S, in_=master)
            i=i+1


class GraphWindow(Canvas):
    def __init__(self,master,
                 x0=0,y0=0,
                 x1=512,y1=512):
        self.x0=x0
        self.y0=y0
        self.x1=x1
        self.y1=y1
        Canvas.__init__(self,background="white",
                        width=self.x1-self.x0,
                        height=self.y1-self.y0)

    def postscript_print(self):
        fname = asksaveasfilename(defaultextension=".ps",
                                  title="File to hold PostScript")
        if fname:
            self.postscript(file=fname)

class SingleGraph(Frame):
    def __init__(self,master,
                 bb=8,
                 x0=0,y0=0,
                 x1=512,y1=512,
                 actions=[]):
        Frame.__init__(self,master)
        
        self.bb=bb
        self.graph=GraphWindow(self,x0=0,y0=0,x1=x1,y1=y1)
        self.graph.grid(row=0,column=0,rowspan=10,padx=self.bb,pady=self.bb)

        actions.append(("PRINT",self.graph.postscript_print))
        self.control=Controls(master,actions)
        self.control.grid(row=0,column=1,
                          rowspan=len(self.control),
                          sticky=N)

class MultiGraph(Frame):
    def __init__(self,master,n=2,
                 bb=8,
                 x0=0,y0=0,
                 x1=550,y1=550,
                 actions=[]):
        Frame.__init__(self,master)
        
        self.bb=bb

        self.graph=[]        
        for i in range(n):
            self.graph.append(GraphWindow(self,x0=0,y0=0,x1=x1,y1=y1))
            self.graph[-1].grid(row=0,column=i,rowspan=10,
                                padx=self.bb,pady=self.bb)

        #for i in range(n):
        #    actions.append(("PRINT "+`i`,
        #                    self.graph[i].postscript_print))
            
        self.control=Controls(master,actions)
        self.control.grid(row=0,column=n,
                          rowspan=len(self.control),
                          sticky=N)

if __name__ == "__main__":
    def hold():
        print "hold"

    def switch():
        print "switch"

    master=Tk()

    i=1

    if i==1:
        
        w=SingleGraph(master,
                      actions=[("HOLD the chips",hold),
                               ("SWITCH ON", "SWITCH OFF",StringVar(),switch)])

        w.graph.create_rectangle(0,0,100,100,outline="yellow",fill="green")

    else:
        w=MultiGraph(master,
                     actions=[("HOLD the chips",hold),
                              ("SWITCH ON", "SWITCH OFF",StringVar(),hold)])
        w.graph[0].create_rectangle(0,0,100,100,outline="yellow",fill="green")
        w.graph[1].create_rectangle(0,0,100,100,outline="yellow",fill="red")

    w.geometry="+0+0"
    master.mainloop()
