function U =solverTh(m,k,b)
% ++++++++++++++++++++++++++++++++++
% MLMC project function
% Written by A. Teckentrup, 2011.
% ++++++++++++++++++++++++++++++++++

% This function solves the linear system arising from a FINITE ELEMENT
% discretisation for the coefficient vector of the solution.

% m is the number of intervals in the mesh.

%A = diag(k(1:m-1)+k(2:m),0) + diag(-k(2:m-1),1) +  diag(-k(2:m-1),-1);
if(m>8)
  A = spdiags([-k(2:m) k(1:m-1)+k(2:m) -k(1:m-1)] ,-1:1,m-1,m-1);
else
  A = diag(k(1:m-1)+k(2:m),0) + diag(-k(2:m-1),1) +  diag(-k(2:m-1),-1);
end
U=A\b;
end
