function [meanSC,costSC] = sc(l,skl,n)
%
% "Stochastic collocation" method (essentially Gauss quadrature)
%
%   inputs:  l     ... grid level
%            skl   ... number of KL modes (choose smaller than 500)
%            n     ... number of collocation points in each dimension
%
%   output:  costSC  ... cost for run in FLOPs
%
%   Note: To balance the FE, truncation and sampling errors, the following 
%         values for skl and eps should be chosen
%
%    sig2=1, nu=1, lam=1:   skl = ceil(0.38*2^(l)), eps = 0.159*2^(-l+1)
%    sig2=1, nu=1, lam=0.1: skl = ceil(1.78*2^(l)), eps = 0.507*2^(-l+1)
%    sig2=1, nu=2, lam=1:   skl = ceil(0.76*2^(l/2)), eps = 0.154*2^(-l+1)
%    sig2=1, nu=1, lam=0.1: skl = ceil(2.38*2^(l/2)), eps = 0.400*2^(-l+1)
%
% ++++++++++++++++++++++++++++++++++
% Written March 2015 by R. Scheichl
% ++++++++++++++++++++++++++++++++++

[xg,wg] = g_data(n);

xsc = icdf('normal',0.5*(xg+1),0,1)
wsc = 0.5*wg;

% Plotting the points for skl = 2
if skl == 2
    
    hold on
    for i=1:n
        plot(xsc,xsc(i)*ones(1,n),'bo')
        axis([-4 4 -4 4]);
    end
    hold off
    
end

% Choose the parameters for the covariance function

nu   = 3;    % smoothness parameter (in [1/2, \infty))
lam  = 1;    % correlation length (> 0) 
sig2 = 1;    % variance (> 0)

% Cost (in FLOPs) to produce one sample

cost = (2*skl+9)*2^l;
costSC = cost * n^skl;

% Grid parameters

hl = 2^(-l);
ml = 1/hl;

% RHs f=1

bl = ones(ml-1,1)*hl^2;

% Set up the KL expansions (using 1000 Gauss points in Nystrom method)

[ev,ef] = klsetup1D_matern(lam,nu,sig2,skl,hl,1000);

Ml = ef*diag(sqrt(ev));

point = ones(skl,1);
weight = 1;

meanSC = pde_recursive(1,skl,point,weight,xsc,wsc,n,Ml,bl,ml)

end

