function y = eval_pde1D(m,u,x)
%
% Evaluate std p.w. linear FE solution in 1D
%
% Input: m = number of elements (assume m>1)
%        u = solution at grid points
%        x = evaluation point
% 
% Output: y = u(x)
%
% ++++++++++++++++++++++++++++++++++
% MLMC project function
% Written 2-3-2015 by R. Scheichl
% ++++++++++++++++++++++++++++++++++

xm = m*x;
ind = floor(xm);
sig = xm-ind;

y=0;
if ind>0
   y = y+(1-sig)*u(ind);
end

if ind<m-1
   y = y+sig*u(ind+1);
end
    
end
    