function uT = pp_euler_path(T,u0,m)
% Euler method to solve predator-prey synamical system (includes plotting)

u=zeros(m+1,2);
u(1,:)=u0;
h = T/m;

for i=1:m

    u(i+1,1) = u(i,1) + h * u(i,1)*(1-u(i,2));
    u(i+1,2) = u(i,2) + h * u(i,2)*(u(i,1)-1);

end

plot(u(:,1),u(:,2),'k-');

uT=u(m+1,:);

end