function [Qmean,stderr,cost] = mlmc(T,u0bar,eps,M,L,N0)
% MLMC simulation to find mean and variance for pred-prey system

s=2;

Q = zeros(1,N0);
Qmean = 0; varerr = 0;

for l=0:L
    
    % On level 0 simply calculate N0 samples (with N0 given).
    %
    % On level l, estimate the variance with an initial number of samples
    % Ninit that decreases on higher levels to avoid unnecessary work,
    % and then calculate the optimal value for N_l
    
    if l==0
        Ninit = N0;  
    else
        Ninit = 16*s^(L-l)
    end
    
    Ml = M*s^(l-L)
    
    du0 = eps*(2*rand(Ninit,2)-1);

    for j=1:Ninit
    
        u0 = u0bar + du0(j,:);
        u = pp_euler(T,u0,Ml);
        if l>0
            uc = pp_euler(T,u0,Ml/s); % only for l>0 we need coarse path
        else
            uc = [0,0];          % to treat l=0 in the same way set uc=0
        end
        
        Q(j) = u(1)-uc(1);
    
    end

    Qvar = var(Q(1:Ninit));
    
    if l>0
        
        % Calculate optimal value for N_l based on the estimates for the
        % variance on level 0 and on level l
        
        N = ceil(2/3 * N0 * sqrt(s^(-l)*Qvar/Qvar0))  
        
        % If N > Ninit do the extra samples
        
        if N > Ninit

            du0 = eps*(2*rand(N-Ninit,2)-1);

            for j=Ninit+1:N
    
                u0 = u0bar + du0(j-Ninit,:);
                u = pp_euler(T,u0,Ml);
                uc = pp_euler(T,u0,Ml/s);
   
                Q(j) = u(1)-uc(1);
                
            end
        end
        cost = cost + 8*(1+1/s)*N*Ml;  % Cost on level l>0 includes also coarse solve

    else
        N = Ninit
        Qvar0 = Qvar;
        cost = 8*N*Ml;
    end
    
    Qmean   = Qmean + mean(Q(1:N));
    varerr = varerr + var(Q(1:N))/N;

end

stderr = sqrt(varerr);

end
