function [Qmean,stderr,cost] = mc_anti(T,u0bar,eps,M,N)
% MC simulation to find mean and variance for pred-prey system
% using antithetic sampling

du = eps*(2*rand(N,2)-1);

Q = zeros(1,N);
Qa = zeros(1,N);

for j=1:N
    
    u0 = u0bar + du(j,:);
    u = pp_euler(T,u0,M);
    
    Q(j) = u(1);
    
    u0 = u0bar - du(j,:);
    u = pp_euler(T,u0,M);

    Qa(j) = u(1); 

end

Qmean = 0.5*(mean(Q) + mean(Qa));
CovQ = cov(Q,Qa); % This produces the covariance matrix
                  % The average of all entries is the covariance
                  % of the estimator

stderr = sqrt(sum(sum(CovQ))/(4*N)); 

cost = 16*N*M;

end
