/*
 * point3.hh
 *
 *  Created on: 2013. 8. 18.
 *      Author: parkmh
 */

#ifndef POINT3_HH_
#define POINT3_HH_

#define RADTODEG  180.0/3.1415926535897932

#include <iostream>
#include <cmath>

template <typename T> class Vec3;

template <typename T>
class Point3
{
public:
	Point3(const T& x, const T& y, const T& z = 0)
	: x_(x), y_(y), z_(z), h_(1.0) {}
	Point3()
	: x_(0.0), y_(0.0), z_(0.0), h_(1.0) {}
	Point3(const Point3& p3)
	: x_(p3.x_), y_(p3.y_), z_(p3.z_), h_(p3.h_){}
	virtual ~Point3(){}
	T norm() const;
	Point3 lerp(T t, const Point3& p3) const;
	Point3& operator=(const Point3&);
	Point3& operator=(const T&);
	T x() const {return x_;}
	T y() const {return y_;}
	T z() const {return z_;}
	T h() const {return h_;}


	friend std::ostream&
	operator<<(std::ostream& os, Point3 &p){
		p.print(os);
		return os;
	}
	T& operator[](size_t i){
		if (i == 0) return x_;
		else if(i == 1) return y_;
		else if(i == 2) return z_;
		else exit(0);
	}

	const T& operator[](size_t i) const{
		if (i == 0) return x_;
		else if(i == 1) return y_;
		else if(i == 2) return z_;
		else exit(0);
	}

	const Point3 &operator+=(const Point3&);
	const Point3 &operator-=(const Point3&);
	const Point3 &operator*=(const T&);

//	const Point3 &operator*=(const Point3&);
//	const Point3 &operator/=(const Point3&);


	virtual void print(std::ostream&);
protected:
	static float EPS;
	T x_,y_,z_,h_;

};

template <typename T>
Point3<T>& Point3<T>::operator=(const Point3<T> &p3){
	if (this != &p3){
		x_ = p3.x_;
		y_ = p3.y_;
		z_ = p3.z_;
	}
	return *this;
}

template <typename T>
Point3<T>& Point3<T>::operator =(const T& val){
	x_ = val;
	y_ = val;
	z_ = val;
	return *this;
}

template <typename T>
T Point3<T>::norm() const {
	return sqrt(x_*x_ + y_*y_ + z_*z_);
}

template <typename T>
void Point3<T>::print(std::ostream & os){
	os << "[" << x_ << ", " << y_ << ", " << z_ << "]";
}

template <typename T>
const Point3<T>& Point3<T>::operator +=(const Point3<T> & p3){
	x_ += p3.x_; 	y_ += p3.y_; 	z_ += p3.z_;
	return *this;
}

template <typename T>
const Point3<T>& Point3<T>::operator -=(const Point3<T> & p3){
	x_ -= p3.x_; 	y_ -= p3.y_; 	z_ -= p3.z_;
	return *this;
}

template <typename T>
const Point3<T>& Point3<T>::operator *=(const T& val){
	x_ *= val; 	y_ *= val; 	z_ *= val;
	return *this;
}

template <typename T>
Point3<T> operator+(const Point3<T>& p1, const Point3<T> & p2){
	return Point3<T>(p1)+= p2;
}

template <typename T>
Vec3<T> operator-(const Point3<T>& p1, const Point3<T> &p2){
	return Vec3<T>(p1[0]-p2[0],p1[1]-p2[1],p1[2]-p2[2]);
}

template <typename T>
Point3<T> operator*(const Point3<T>& p, const T& val){
	return Point3<T>(p)*= val;
}

template <typename T>
Point3<T> operator*(const T& val, const Point3<T>& p){
	return Point3<T>(p)*= val;
}
template <typename T>
inline Point3<T> operator-(const Point3<T>& p1) {
	return Point3<T>(-p1[0],-p1[1],-p1[2]);
}

template <typename T>
Point3<T> Point3<T>::lerp(T t, const Point3& p3) const{
	return Point3<T>((1-t)*x_+t*p3.x_, (1-t)*y_+t*p3.y_, (1-t)*z_+t*p3.z_);
}

template <typename T>
float Point3<T>::EPS = (float)1.E-6;



template <typename T>
class Vec3:public Point3< T >{
private:
//	static float RADTODEG;
public:
	Vec3(T x, T y, T z = 0) : Point3<T>(x,y,z)
	{ this->h_ = 0;}
	Vec3()
	{ this->h_ = 0;}
	~Vec3(){};
	void print(std::ostream&);
	void normalise();
	friend std::ostream&
	operator<<(std::ostream& os, Vec3 &v){
		v.print(os);
		return os;
	}

	const Vec3 &operator+=(const Vec3&);
	const Vec3 &operator-=(const Vec3&);
	const Vec3 &operator*=(const T&);


	static const Vec3* e1;
	static const Vec3* e2;
	static const Vec3* e3;
};

//template <typename T>
//float Vec3<T>::RADTODEG = 180.0/3.1415926535897932;
template <typename T>
const Vec3<T>* Vec3<T>::e1 = new Vec3<T>(1,0,0);
template <typename T>
const Vec3<T>* Vec3<T>::e2 = new Vec3<T>(0,1,0);
template <typename T>
const Vec3<T>* Vec3<T>::e3 = new Vec3<T>(0,0,1);

template <typename T>
const Vec3<T>& Vec3<T>::operator+=(const Vec3<T> &v){
	this->x_ += v[0];
	this->y_ += v[1];
	this->z_ += v[2];

	return *this;
}


template <typename T>
const Vec3<T>& Vec3<T>::operator-=(const Vec3<T> &v){
	this->x_ -= v[0];
	this->y_ -= v[1];
	this->z_ -= v[2];

	return *this;
}

template <typename T>
const Vec3<T>& Vec3<T>::operator*=(const T &val){
	this->x_ *= val; 	this->y_ *= val; 	this->z_ *= val;
	return *this;
}

template <typename T>
Vec3<T> operator+(const Vec3<T>& p1, const Vec3<T> & p2){
	return Vec3<T>(p1)+= p2;
}

template <typename T>
Vec3<T> operator-(const Vec3<T>& p1, const Vec3<T> &p2){
	return Vec3<T>(p1)+= p2;
}

template <typename T>
Vec3<T> operator*(const Vec3<T>& p, const T& val){
	return Vec3<T>(p)*= val;
}

template <typename T>
Vec3<T> operator*(const T& val, const Vec3<T>& p){
	return Vec3<T>(p)*= val;
}
template <typename T>
inline Vec3<T> operator-(const Vec3<T>& p1) {
	return Point3<T>(-p1[0],-p1[1],-p1[2]);
}

template <typename T>
void Vec3<T>::normalise(){
	T length = this->norm();
	if (length < this->EPS){
		return;
	}
	this->x_/=length;
	this->y_/=length;
	this->z_/=length;
}
template <typename T>
void Vec3<T>::print(std::ostream &os){
	os << "(" << this->x_ << ", " << this->y_ << ", " << this->z_ << ")";
}

template <typename T>
Vec3<T> cross(const Vec3<T>& v1, const Vec3<T>& v2){
	return Vec3<T>(v1[1]*v2[2]-v1[2]*v2[1],
			        v1[2]*v2[0]-v1[0]*v2[2],
			        v1[0]*v2[1]-v1[1]*v2[0]);
}
template <typename T>
T dot(const Vec3<T>& v1, const Vec3<T>& v2){
	return v1[0]*v2[0]+v1[1]*v2[1]+v1[2]*v2[2];
}

template <typename T>
T angle(const Vec3<T>& v1, const Vec3<T>& v2){
	T magnitude = v1.norm()*v2.norm();
	T angle = acos(dot<T>(v1,v2)/magnitude);
	return angle*RADTODEG;
}

template <typename T>
T angle2(const Vec3<T>& v1, const Vec3<T>& v2){
	T magnitude = v1.norm()*v2.norm();
	T angle = atan2((cross<T>(v1,v2)).norm(),dot<T>(v1,v2));
	return angle*RADTODEG;
}

template <typename T>
T signedAngle(const Vec3<T>& v1, const Vec3<T>& v2, const Vec3<T>& v3){
	Vec3<T> n = cross<T>(v1,v2);
	T ang = angle<T>(v1,v2);
	if (dot<T>(n,v3) < 0) ang = -ang;
	return ang;
}


template <typename T>
Vec3<T> reflect(const Vec3<T>& v, const Vec3<T>& n){
	T term  = 2*dot<T>(v,n);
	return term*n - v;
}
#endif /* POINT3_HH_ */
