/*
 * graph.hh
 *
 *  Created on: 2013. 8. 6.
 *      Author: parkmh
 */

#ifndef GRAPH_HH_
#define GRAPH_HH_

#include "list.hh"
#include "crs_matrix.hh"
#include <iostream>

typedef int Vertex;
class Graph;
template <class T> class Cholesky;

class Graph {
	template <class T> friend class Cholesky;
public:
	Graph( const int vertices = 0 ): size_(vertices)
	{ 	HeadNodes = new List<int>[ size_ ]; };
	template <class T>
	void create(const CRSMatrix<T>&);
	~Graph( ) { delete [] HeadNodes;}
	void insertEdge( Vertex, Vertex );
	void removeEdge( Vertex, Vertex );
	void removeVertex( Vertex );
	void setN( const size_t newN ) { size_ = newN;}
	size_t getN(){ return size_; }
	void setHead( List<int> *newHead ) { HeadNodes = newHead; }
	friend std::ostream&	operator<<(std::ostream& os, const Graph& G){
		os << std::endl;
		os << "GRAPH(" << G.size_ << ")" << std::endl;

		for( size_t i = 0; i< G.size_  ; i++)
		{
			os << "[ " << i << " ] " << G.HeadNodes[ i ];
		}
		return os;
	}
private:
	List< int > *HeadNodes;
	size_t size_;
};


template <class T>
void Graph::create(const CRSMatrix<T> &A){
	size_t i, j, iai, iaip1;
	if ( size_ != A.row() )
	{
		size_ = A.row();
		delete [] HeadNodes;
		setN(size_);
		HeadNodes = new List< int >[ size_ ];
	}

	iai = A.ia(0);
	for(i = 0; i < size_; i++ ) {
		iaip1 = A.ia( i + 1 );
		for (j = iai; j < iaip1; j ++ ){
			if (i != A.ja( j ) ) {
				HeadNodes[ i ].insertAtBack( A.ja( j ) );
			}
		}
		iai = iaip1;
	}
}

void Graph::insertEdge( Vertex u, Vertex v )
{
	if (!HeadNodes[ u ].isIn( v )){
		HeadNodes[ u ].insertAtFront(v);
		HeadNodes[ v ].insertAtFront(u);
	}

}

void Graph::removeEdge( Vertex u, Vertex v )
{
	if (HeadNodes[ v ].removeAny( u ) ){
		HeadNodes[ u ].removeAny( v );
	}

}

void Graph::removeVertex( Vertex u )
{
	ListNode< int > *currentPtr = HeadNodes[u].getFirstPtr();
	Vertex v = 0;
	while (currentPtr != HeadNodes[u].getLastPtr() ){
		v = (*currentPtr).getData();
		currentPtr = (*currentPtr).getNextPtr();

		removeEdge(u,v);
	}

	v = (*currentPtr).getData();
	removeEdge(u,v);
}


#endif /* GRAPH_HH_ */
