/*
 * grid.hh
 *
 *  Created on: 2013. 7. 27.
 *      Author: parkmh
 */

/*
 * Changelog
 	 * v.0.1 Added grid.hh
 	 *
 */

#ifndef GRID_HH_
#define GRID_HH_

#include <vector>
#include <ostream>
#include <fstream>
#include "element.hh"


template <class Element> class Grid:public std::vector<Element>{
public:
	static const int NNode = Element::NNode;
	static const int Dim = Element::Dim;

	Element& operator[](size_t n){
		return this->at(n);
	}

	const Element& operator[](size_t n) const{
		return this->at(n);
	}

	friend std::ostream&
	operator<<(std::ostream& os, const Grid &g){
		os << "[(nelem=" << g.size() << ")]" << std::endl;
		for (size_t i = 0; i < g.size(); i++)
			os << "[" << i  << "]" << g[i] <<std::endl;
		return os;
	}

	void save(const char*);
};

template <class Element>
void Grid<Element>::save(const char* filename){
	std::ofstream file;
	file.open(filename);

	file << "# Number of elements" << std::endl;
	file << this->size() << std::endl;
	file << "# Number of nodes in each element" << std::endl;
	file << Element::NNode << std::endl;
	file << "# Indices in each element" << std::endl;
	for (int i = 0; i < this->size(); i++){
		for (int j = 0; j < Element::NNode; j++){
			file << (this->operator [](i))[j] << std::endl;
		}
	}
	file.close();
}

#endif /* GRID_HH_ */
