/*
 * list.hh
 *
 *  Created on: 2013. 8. 6.
 *      Author: parkmh
 */

#ifndef LIST_HH_
#define LIST_HH_

#include "listnd.hh"
#include <cassert>
#include <iostream>

template< class NODETYPE > class ListNode;
template< class NODETYPE> class List;

template< class T > std::ostream& operator<<(std::ostream&, const List< T > & );

template< class NODETYPE >
class List {
	friend class ListNode< NODETYPE >;
public:
	List();	// constructor
	~List(); // destructor
	void insertAtFront( const NODETYPE & );
	void insertAtBack( const NODETYPE & );
	NODETYPE getFirst( );
	bool removeFromFront( NODETYPE & );
	bool removeFromBack( NODETYPE & );
	bool removeAny( const NODETYPE & );
	void removeAll();
	bool isIn( const NODETYPE & );
	bool isEmpty() const;
	int  getLength() const{ return length;}
	void print() const;
	friend std::ostream&	operator<<<>(std::ostream& , const List& );
	ListNode< NODETYPE > * getFirstPtr() { return firstPtr; }
	ListNode< NODETYPE > * getLastPtr() { return lastPtr; }


private:
	ListNode< NODETYPE > *firstPtr;	// pointer to first node
	ListNode< NODETYPE> *lastPtr;	// pointer to last node
	int length;
	// Utility function to allocate a new node
	ListNode< NODETYPE > *getNewNode( const  NODETYPE & );
};

// Default Constructor
template< class NODETYPE >
List< NODETYPE >::List() : firstPtr( 0 ), lastPtr( 0 ) ,length(0){ }

// Destructor
template< class NODETYPE >
List< NODETYPE >::~List()
{
	if( !isEmpty() ) {	// List is not empty

		ListNode< NODETYPE > *currentPtr = firstPtr, *tempPtr;

		while ( currentPtr != 0 ) {	// delete remaining nodes
			tempPtr = currentPtr;
			//			std::cout <<INDEX( tempPtr->data) << std::endl;
			currentPtr = currentPtr->nextPtr;
			delete tempPtr;
		}
	}

}

// Insert a node at the front of the list
template < class NODETYPE >
void List< NODETYPE >::insertAtFront( const NODETYPE &value )
{
	ListNode< NODETYPE> *newPtr =
			new ListNode< NODETYPE >( value );
	//	ListNode< NODETYPE > *newPtr = getNewNode( value );

	if ( isEmpty() ) // List is empty
		firstPtr = lastPtr = newPtr;
	else {
		newPtr->nextPtr = firstPtr;
		firstPtr = newPtr;
	}
	length += 1;
}

// Insert a node at the back of the list
template < class NODETYPE >
void List< NODETYPE >::insertAtBack( const NODETYPE &value )
{
	ListNode< NODETYPE> *newPtr =
			new ListNode< NODETYPE >( value );
	//	ListNode< NODETYPE > *newPtr = getNewNode( value );

	if ( isEmpty() ) // List is empty
		firstPtr = lastPtr = newPtr;
	else {
		lastPtr->nextPtr = newPtr;
		lastPtr = newPtr;
	}
	length += 1;
}

// Delete a node from the front of the list
template < class NODETYPE >
bool List< NODETYPE >::removeFromFront( NODETYPE &value )
{
	if ( isEmpty() ) // List is empty
		return 1;	// delete unsuccessful
	else {
		ListNode< NODETYPE > *tempPtr = firstPtr;

		if ( firstPtr == lastPtr )
			firstPtr = lastPtr = 0;
		else
			firstPtr = firstPtr->nextPtr;

		value = tempPtr->data;	// data being removed
		delete tempPtr;
		length -= 1;
		return 0;			// delete successful
	}
}

// Delete a node from the front of the list
template < class NODETYPE >
void List< NODETYPE >::removeAll()
{
	if ( isEmpty() ) // List is empty
		return 1;	// delete unsuccessful
	else {
		ListNode< NODETYPE > *tempPtr;
		while (isEmpty()){
			if ( firstPtr == lastPtr )
				firstPtr = lastPtr = 0;
			else
			{
				tempPtr = firstPtr;
				firstPtr = firstPtr->nextPtr;
				delete tempPtr;
				length--;
			}
		}
	}
}
template < class NODETYPE>
NODETYPE List< NODETYPE >::getFirst( )
{
	//	std::cout << "CALL" ;
	NODETYPE returnVal = 0;
	if ( isEmpty() ) // List is empty
		return -1;	// delete unsuccessful
	else {
		ListNode< NODETYPE > *tempPtr = firstPtr;

		if ( firstPtr == lastPtr )
			firstPtr = lastPtr = 0;
		else
			firstPtr = firstPtr->nextPtr;

		returnVal = tempPtr->data;	// data being removed
		delete tempPtr;
		length -= 1;
		return returnVal;
	}
}

// Delete a node from the front of the list
template < class NODETYPE >
bool List< NODETYPE >::removeFromBack( NODETYPE &value )
{
	if ( isEmpty() ) // List is empty
		return 1;	// delete unsuccessful
	else {
		ListNode< NODETYPE > *tempPtr = lastPtr;

		if ( firstPtr == lastPtr )
			firstPtr = lastPtr = 0;
		else {
			ListNode<NODETYPE> *currentPtr = firstPtr;

			while ( currentPtr->nextPtr != lastPtr )
				currentPtr = currentPtr->nextPtr;
			lastPtr = lastPtr->nextPtr;
			currentPtr->nextPtr = 0;
		}
		value = tempPtr->data;	// data being removed
		delete tempPtr;
		length -= 1;
		return 0;			// delete successful
	}
}

// Remove value if matched
template< class NODETYPE >
bool List<NODETYPE>::removeAny( const NODETYPE &value )
{
	if ( isEmpty() ){
		return 0;
	}
	else {
		ListNode< NODETYPE > *currentPtr = firstPtr;
		if ( currentPtr->data == value ){
			firstPtr = firstPtr->nextPtr;
			length -=1;
			delete currentPtr;
			return 1;
		}
		else {
			ListNode< NODETYPE > *NextPtr;
			NextPtr = currentPtr->nextPtr;
			while( NextPtr != lastPtr ){
				if ( NextPtr->data == value ) {
					currentPtr->nextPtr = NextPtr->nextPtr;
					length -= 1;

					delete NextPtr;
					while ( currentPtr->nextPtr != lastPtr)
						currentPtr = currentPtr-> nextPtr;
					return 1;
				}
				else {
					currentPtr = currentPtr -> nextPtr;
					NextPtr = NextPtr -> nextPtr;
				}
			}

			if (lastPtr->data == value){
				NextPtr = lastPtr;
				lastPtr = currentPtr;
				lastPtr->nextPtr = 0;
				length -= 1;
				delete NextPtr;
				return 1;
			}
			delete NextPtr;

			return 0;
		}
	}
}

// Is the value in List
template< class NODETYPE >
bool List<NODETYPE>::isIn( const NODETYPE &value )
{
	if ( isEmpty() )
		return 0;
	else {
		ListNode< NODETYPE > *currentPtr = firstPtr;
		if ( currentPtr->data == value )
			return 1;
		currentPtr = currentPtr->nextPtr;

		while( currentPtr != lastPtr ){
			if ( currentPtr->data == value ) {
				return 1;
			}
			else {
				currentPtr = currentPtr->nextPtr;
			}
		}
		if (lastPtr->data == value){
			return 1;
		}
		return 0;
	}
}

// Is the List empty?
template< class NODETYPE >
bool List< NODETYPE >::isEmpty() const
{ 	return firstPtr == 0; }

// return a pointer to a newly allocated node
template< class NODETYPE >
ListNode< NODETYPE > *List<NODETYPE>::getNewNode( const NODETYPE &value )
{
	ListNode< NODETYPE> *ptr =
			new ListNode< NODETYPE >( value );
	assert( ptr != 0 );
	return ptr;
}

// Display the contents of the List
template< class NODETYPE >
void List< NODETYPE >::print() const
{
	if ( isEmpty() ) {
		std::cout << " The List is empty\n\n";
		return;
	}

	ListNode< NODETYPE > *currentPtr = firstPtr;
	std::cout << "The list is: ";
	while( currentPtr != 0 ) {
		std::cout << currentPtr->data << ' ';
		currentPtr = currentPtr->nextPtr;
	}
	std::cout << std::endl<<std::endl;
}

template < class NODETYPE >
std::ostream&	operator<<(std::ostream& os, const List< NODETYPE >& L)
{
	if (L.isEmpty()) {
		os << "[ 0 ]  Empty list \n";
		return os;
	}
	ListNode< NODETYPE > *currentPtr = L.firstPtr;
	os << "[ " << " n = "<< L.getLength() << " ] ";
	while( currentPtr != 0 ) {
		os << (*currentPtr).getData() << ' ';
		currentPtr = (*currentPtr).getNextPtr();
	}
	os << std::endl;

	return os;
}


#endif /* LIST_HH_ */
