/*
 * coordinates.hh
 *
 *  Created on: 2013. 7. 28.
 *      Author: parkmh *
 */

/*
 * Changelog
 	 * v.0.1 Added coordinates.hh
 	 *
 */

#ifndef COORDINATES_HH_
#define COORDINATES_HH_

#include <vector>
#include <fstream>

#include "point.hh"
template<int dim,class T> class Coordinates:public std::vector< Point<dim, T> >{
public:
	friend std::ostream&
	operator<<(std::ostream& os, const Coordinates &co){
		os << "[(npoint=" <<  co.size() << ")]" << std::endl;
		for (size_t i = 0; i < co.size(); i++){
			os << "[" << i << "]" << co[i] << std::endl;
		}
		return os;
	}

	Point<dim,T>& operator[] (size_t n){
		if (n > this->size())
			throw std::out_of_range("Bad coordinates index");
		return this->at(n);
	}

	const Point<dim,T>& operator[] (size_t n) const {
		if (n > this->size())
			throw std::out_of_range("Bad coordinates index");
		return this->at(n);
	}
	void save(const char* );
};

template<int dim, class T> void Coordinates<dim,T>::save(const char * filename){
	std::ofstream file;
	file.open(filename);

	file << "# Number of nodes" << std::endl;
	file << this->size() << std::endl;
	file << "# x y z coordinates" << std::endl;
	for(int i = 0; i < this->size(); i++){
		for (int j = 0; j < dim; j++){
			file << (this->operator [](i)).operator [](j) << std::endl;
		}
		for (int j = dim; j < 3; j++){
			file << "0" << std::endl;
		}
	}
	file.close();
}
/*
 * TODO
 */

/*
template<int dim> class Coordinates{
public:
	Coordinates() {npoint = 0;}			// default constructor
	Coordinates(const Coordinates&);	// copy constructor
	Coordinates& operator=(const Coordinates&);	// assignment operator

	void pushback(const Point<dim>&);
	void clear() {coord.clear();}

	private:
	size_t npoint;
	std::vector< Point<dim> > coord;
};

template<int dim>
Coordinates<dim>::Coordinates(const Coordinates& co){
	npoint = co.npoint;
	coord = co.coord;
}

template <int dim>
Coordinates<dim>& Coordinates<dim>::operator =(const Coordinates<dim>& co){
	if (this != &co){
		npoint = co.npoint;
		coord = co.coord;
	}
	return *this;

}

template <int dim>
void Coordinates<dim>::pushback(const Point<dim> &p){
	coord.push_back(p);
	npoint = coord.size();
}

 */
#endif /* COORDINATES_HH_ */
