/*
 * relaxation_jacobi.hh
 *
 *  Created on: 2013. 9. 7.
 *      Author: parkmh
 */

#ifndef RELAXATION_JACOBI_HH_
#define RELAXATION_JACOBI_HH_

#include "relaxation.hh"
#include <iostream>
template <class CRSMAT>
class Jacobi : public Relaxation<CRSMAT>{
public:
	typedef typename CRSMAT::datatype datatype;
	Jacobi();
	Jacobi(const CRSMAT& , size_t);
	void setweight(double weight){w = weight;}
	void init(const CRSMAT& , size_t);
	void solve(const NumVec<datatype> &, NumVec<datatype> &x) const;
	void print(std::ostream &) const;
private:
	const CRSMAT *A;
	double w;
	NumVec<int> diag;
	int * dp;
};

template <class CRSMAT>
Jacobi<CRSMAT>::Jacobi()
{
	A = NULL;
	w = 0.0;
	dp = NULL;
}

template <class CRSMAT>
Jacobi<CRSMAT>::Jacobi(const CRSMAT&a, size_t niter = 1)
{ init(a,niter);}

template <class CRSMAT>
void Jacobi<CRSMAT> ::init(const CRSMAT&a, size_t niter = 1)
{
	this->A_ = &a;
	this->n_ = a.row();
	this->niter_ = niter;
	w = RELAX_WEIGHT;
	A = (this->A_);
	diag.resize(A->row());
	diag = A->diag();
	dp = diag.begin();
}

template <class CRSMAT>
void Jacobi<CRSMAT> ::solve(const NumVec<datatype>& rhs, NumVec<datatype> &x) const {
	if (A->col() != x.size()){
		std::cerr << "??? error using ==> gauss_seidel \n Dimension of both matrix and vector must agree \n";
		exit(0);
	}
	datatype var, d;
	size_t ajaj, iai,iaip1, nRow;
	nRow = this->n_;
	double wc = 1-w;
	datatype *xp = x.begin();

	const size_t * iap = A->iabegin();
	const size_t * jap = A->jabegin();
	const datatype *aap = A->aabegin();
	const datatype *rhsp = rhs.begin();
	NumVec<datatype> xnew; xnew.resize(A->row());
	if (w == 1.0){
		for (size_t iter = 0; iter < this->niter_; iter++){
			iai = *iap;
			for (size_t i = 0; i < nRow; i++ ){
				var = 0;
				iaip1 = *(iap+i+1);
				d = datatype();
				for (size_t j = iai; j < iaip1; j++){
					ajaj = *(jap+j);
					if(i != ajaj){ var += *(aap+j) * x[ajaj] ;}
					else {d = *(aap+j);}
				}
				iai = iaip1;
				xnew[i] = (*(rhsp+i) - var)/d;

			}
			x = xnew;
		}
	}
	else {
		for (size_t iter = 0; iter < this->niter_; iter++){
			iai = *iap;
			for (size_t i = 0; i < nRow; i++ ){
				var = 0;
				iaip1 = *(iap+i+1);
				d = datatype();
				for (size_t j = iai; j < iaip1; j++){
					ajaj = *(jap+j);
					if(i != ajaj){ var += *(aap+j) * x[ ajaj] ;}
					else {d = *(aap+j);}
				}
				iai = iaip1;
				xnew[i] = w*(*(rhsp+i) - var)/d + wc* x[i];
			}
			x = xnew;

		}
	}

}

template <class CRSMAT>
void Jacobi<CRSMAT> ::print(std::ostream& os) const {
	if (w == 1.0){
		os << "Jacobi [niter = "
				<< this->niter_ <<"]";
	} else{
		os << "Weighted Jacobi [niter = "
				<< this->niter_ <<", w = " << w<<"]";
	}
}


#endif /* RELAXATION_JACOBI_HH_ */
