/*
 * relaxation_gs.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */

/*
 * Changelog
 * v.0.1 Added relaxation_gs.hh.
 *
 */

#ifndef RELAXATION_GS_HH_
#define RELAXATION_GS_HH_

#ifndef RELAXATION_HH
#include "relaxation.hh"
#endif

#include <iostream>
template <class CRSMAT>
class GS : public Relaxation<CRSMAT>{
public:
	typedef typename CRSMAT::data_type data_type;
	GS();
	GS(const CRSMAT& , size_t);
	void init(const CRSMAT& , size_t);
	void solve(const NumVec<data_type> &, NumVec<data_type> &x) const;
	void print(std::ostream &) const;
private:
	const CRSMAT *A;
	double w;
	NumVec<int> diag_;

};

template <class CRSMAT>
GS<CRSMAT>::GS()
{
	A = NULL;
	w = 0.0;
}

template <class CRSMAT>
GS<CRSMAT>::GS(const CRSMAT&a, size_t niter = 1)
{ init(a,niter);}

template <class CRSMAT>
void GS<CRSMAT> ::init(const CRSMAT&a, size_t niter = 1)
{
	this->A_ = &a;
	this->n_ = a.row();
	this->niter_ = niter;
	w = RELAX_WEIGHT;
	A = (this->A_);
	diag_.resize(A->row());
	diag_ = A->diag();

}

template <class CRSMAT>
void GS<CRSMAT> ::solve(const NumVec<data_type>& rhs, NumVec<data_type> &x) const {
	if (A->col() != x.size()){
		std::cerr << "??? error using ==> gauss_seidel \n Dimension of both matrix and vector must agree \n";
		exit(0);
	}
	data_type sum, diag;
	size_t ajaj, iai,iaip1, nRow;
	nRow = this->n_;
	double wc = 1-w;
	data_type *xp = x.begin();
	const int* dp = diag_.begin();
	const size_t * iap = A->iabegin();
	const size_t * jap = A->jabegin();
	const data_type *aap = A->aabegin();
	const data_type *rhsp = rhs.begin();

	size_t j;
	if (w == 1.0){
		for (size_t iter = 0; iter < this->niter_; iter++){

			iai = *iap;
			for (size_t i = 0; i < nRow; i++ ){
				iaip1 = *(iap+i+1);
				diag = *(aap +*(dp+i));
				sum = -diag* *(xp+i);
				for (j = iai; j < iaip1; j++){
					sum += (*(aap+j) * *(xp + *(jap+j)));
				}
				iai = iaip1;
				*(xp+i) = (*(rhsp+i) - sum)/diag;
			}
		}
	}
	else {
		for (size_t iter = 0; iter < this->niter_; iter++){
			iai = *iap;
			for (size_t i = 0; i < nRow; i++ ){
				sum = 0;
				iaip1 = *(iap+i+1);
				diag= data_type();
				for (size_t j = iai; j < iaip1; j++){
					ajaj = *(jap+j);
					if(i != ajaj){ sum += *(aap+j) * *(xp + ajaj) ;}
					else {diag= *(aap+j);}
				}
				iai = iaip1;
				*(xp+i) = w*(*(rhsp+i) - sum)/diag+ wc* *(xp+i);
			}
		}
	}
}

template <class CRSMAT>
void GS<CRSMAT> ::print(std::ostream& os) const {
	if (w == 1.0){
		os << "Gauss Seidel [niter = "
				<< this->niter_ <<"]";
	} else{
		os << "SOR [niter = "
				<< this->niter_ <<", w = " << w<<"]";
	}
}
#endif /* RELAXATION_GS_HH_ */
