/*
 * interpolation.hh
 *
 *  Created on: 2013. 8. 9.
 *      Author: parkmh
 */

#ifndef INTERPOLATION_HH_
#define INTERPOLATION_HH_

#include "../util/config.hh"
#include "../math/crs_matrix.hh"
#include <vector>
#include <cmath>
#include <iostream>

template <class CRSMAT>
class INTP{
public:
	typedef typename CRSMAT::data_type data_type;
	INTP(){ A_ = NULL; }

	virtual ~INTP() {};
	virtual void init(const CRSMatrix<data_type>&, CSN<data_type> &) = 0;
	virtual void print(std::ostream&) const = 0;
	virtual void prolong(const NumVec<data_type> &, NumVec<data_type> &) const = 0;
	virtual void correct(const NumVec<data_type> &, NumVec<data_type> &) const = 0;
	const CRSMAT* operator() ()const { return &P_;}
	friend std::ostream&
	operator<<(std::ostream& os, const INTP& intp){
		intp.print(os);
		return os;
	}

protected:
	const CRSMAT *A_;
	CRSMAT P_;
};


#endif /* INTERPOLATION_HH_ */
