/*
 * csn_aggcsn.hh
 *
 *  Created on: 2013. 8. 17.
 *      Author: parkmh
 */

#ifndef CSN_AGGCSN_HH_
#define CSN_AGGCSN_HH_

#define CPOINT 1
#define FPOINT 0

#define UNUSED -1
#define LAST   -2
#define FIRST  -2

//#include "csn.hh"
#include "csn_amgcsn.hh"

template <typename T>
class AGGCSN:public CSN<T>{
public:
	typedef T datatype;
	AGGCSN();
	AGGCSN(const CRSMatrix<T> &);
	void init(const CRSMatrix<T> &);
	const size_t& rows(size_t n) const { return nbd_row[n];}
	const size_t& cols(size_t n) const { return nbd_col[n];}

	void print(std::ostream & ) const;
protected:
	AMGCSN<T> C1;
	const CRSMatrix<T> *A;
	CRSMatrix<int> S_;
	NumVec<size_t> RowS_, ColS_, RowST_, ColST_;
	NumVec<size_t> nbd_row, nbd_col;
	NumVec< int > nofconnection_;

	void strong_connection();
	void first_coloring();
	void second_coloring();
};

template <typename T>
AGGCSN<T>::AGGCSN(){
	A = NULL;
}

template <typename T>
AGGCSN<T>::AGGCSN(const CRSMatrix<T> &a){
	init(a);
}

template <typename T>
void AGGCSN<T>::init(const CRSMatrix<T>& a){
	C1.init(a);
	this->A_ = &a;
	A = (this->A_);
	this->nf_ = A->row();
	this->C_.resize(this->nf_);
	this->C_ = false;

	strong_connection();
	first_coloring();
	this->compute_nc();
}

template <typename T>
void AGGCSN<T>::strong_connection(){
	size_t m = A->row();
	int maxnnzrow, nnzrow;
	int j, k, l, iai, iaip1, aiajaj, aiajajp1;
	size_t i, jak, jaj;
	int nbdindex, nbdsize, isinnbd, inbdi, inbdip1;
	int *len2nbd, len2start, *npath;
	size_t nsti;
	size_t *jnbd;

	maxnnzrow = 0;

	RowS_.resize(m+1);
	RowST_.resize(m+1);

	iai = A->ia(0);
	for ( i = 0; i < m; i++){
		iaip1 = A->ia(i+1);
		nnzrow = iaip1 - iai;
		iai = iaip1;
		if (nnzrow > maxnnzrow)
			maxnnzrow =nnzrow;
	}

	size_t worst_nnz = maxnnzrow*maxnnzrow*m;

	ColS_.resize(worst_nnz);
	ColST_.resize(worst_nnz);

	NumVec<size_t> nS(m);
	NumVec<size_t> nST(m);

	std::vector< std::vector< size_t > > jjt(m);


	nbd_row.resize(m+1);
	nbd_row = 0;

	jnbd = new size_t[worst_nnz];


	len2nbd = new int[maxnnzrow*maxnnzrow];
	npath   = new int[m];
	nbdindex = 0;

	NumVec<bool> isInNbd(m);

	iai = A->ia(0);
	for (i = 0; i < m; i++){
		jjt[i].reserve(maxnnzrow*maxnnzrow);
		nbdsize = 0;
		iaip1 = A->ia(i+1);
		npath[i] = 0;
		for (j = iai; j < iaip1; j++){
			jaj = A->ja(j);
			if (i != jaj){
				len2nbd[nbdsize] = jaj;
				isInNbd[jaj] = true;
				nbdsize++;
			}
		}
		len2start = nbdsize;

		// Check length 2 connections
		for (j = iai; j < iaip1; j++){
			jaj = A->ja(j);
			if (i!= jaj){
				aiajaj = A->ia(jaj);
				aiajajp1 = A->ia(jaj+1);
				for (k = aiajaj;k < aiajajp1; k++){
					isinnbd = 0;
					jak = A->ja(k);
					if ((jak != i) && (jak != jaj) && (!isInNbd[jak])){
						jnbd[ nbdindex ] = jak;
						len2nbd[ nbdsize ] = jak;
						isInNbd[jak] = 1;
						nbdsize++;
						nbdindex++;
					}
				}
			}
		}

		for (j = 0; j < nbdsize; j++){
			isInNbd[len2nbd[j]] = false;
		}
		iai = iaip1;
		nbd_row[ i + 1 ] = nbd_row[ i ] + nbdsize - len2start;
	}

	int index = 0;
	RowS_[ 0 ] = 0;

	iai = A->ia(0);
	inbdi = nbd_row[0];
	for (i = 0; i < m; i++) {

		iaip1 = A->ia(i+1);
		inbdip1 = nbd_row[i+1];
		if ( C1( i ) ){
			for ( j = iai; j < iaip1;j++){
				jaj = A->ja(j);
				if (!C1(jaj)){
					aiajaj = A->ia(jaj);
					aiajajp1 = A->ia(jaj+1);
					for ( k = aiajaj; k < aiajajp1; k++){
						jak = A->ja(k);
						isinnbd = 0;
						for (l = inbdi; l < inbdip1; l++){
							if (jnbd[l] == jak){
								isinnbd = 1;
								break;
							}
						}
						if (isinnbd) {
							if (C1(jak) && jak != i){
								npath[ jak ]++;
							}
						}
					}
				}
			}
			for (j = iai; j < iaip1;j++){
				jaj = A->ja(j);
				if (!C1(jaj)){
					aiajaj = A->ia(jaj);
					aiajajp1 = A->ia(jaj+1);
					for (k = aiajaj; k < aiajajp1; k++){
						jak = A->ja(k);
						if (C1(jak)&& jak!=i && npath[jak] > 0){
							if (npath[jak] >= NPATH){
								ColS_[ index ] = jak;
								nS[i]++;
								jjt[jak][nST[jak]] = i;
								nST[jak]++;
								index++;
							}
							npath[ jak ] = 0;
						}
					}
				}
			}

		}
		RowS_[ i + 1 ] = index;
		iai = iaip1;
		inbdi = inbdip1;
	}

	RowST_[0] = 0;
	index = 0;
	for (i = 0; i < m; i++){
		nsti = nST[ i ];
		for (j = 0; j < nsti; j++){
			ColST_[ index ]	= jjt[ i ][ j ];
			index++;
		}
		RowST_[ i + 1 ] = RowST_[ i ] + nsti;
	}
	nbd_col.assign(jnbd,nbdindex);

	ColS_.shrink(index);


	delete []jnbd;

	delete []len2nbd;
	delete []npath;
}


template <typename T>
void AGGCSN<T>::first_coloring(){
	int nRow = A->row();
//	CVector< bool > C2(nRow);
//	CMatrix< int > TS2;
//	TS2 = transpose<int>(S2);
//
	NumVec< int > nofc(nRow);
	NumVec< int > prev_index(nRow,UNUSED);
	NumVec< int > next_index(nRow,UNUSED);
	NumVec< int > first_index(nRow,UNUSED);

	int ts2iai, ts2iaip1,s2iai, s2iaip1;
	int max_lambda = 0;
	int lambda;

	int assigned_index = 0; // The number of assigned nodes.
	int temp_index;
	int max_index;
	int i, l, j, k, s2jak, ts2jaj;
	int ts2iamax, ts2iamaxp1, s2iats2jaj, s2iats2jajp1;
	int nofcs2jak, nofcts2jaj;

	ts2iai = RowST_[0];
	s2iai = RowS_[0];

//	 Initialise nofc and double linked list, and update max_lambda
	for (i = 0; i < nRow; i++) {
		ts2iaip1 = RowST_[i+1];
		s2iaip1 = RowS_[i+1];
		lambda = ts2iaip1 - ts2iai + s2iaip1 - s2iai;
		nofc[ i ] = lambda;
		if (lambda > 0) {
			if (max_lambda < lambda) { // Update maximum lambda value
				max_lambda = lambda;
			}

			if (first_index[ lambda ] == UNUSED) { // First new node
				first_index[ lambda ] = i;
				prev_index[ i ] = FIRST;
				next_index[ i ] = LAST;
			} else { // Add new node
				prev_index[ first_index[ lambda ] ] = i;
				next_index[ i ] = first_index[ lambda ];

				prev_index[ i ] = FIRST;
				first_index[ lambda ] = i;
			}
		}
		ts2iai = ts2iaip1;
		s2iai = s2iaip1;
	}

	/*
	 * First Coloring Pass
	 */

	while (assigned_index != nRow) {
		if (max_lambda > 0) {
			max_index = first_index[ max_lambda ];
			temp_index = max_index;

			while (next_index[ temp_index ] != LAST) { // if NOT last node
				if (max_index > next_index[ temp_index ]) {
					max_index = next_index[ temp_index ];
				}
				temp_index = next_index[ temp_index ];
			} // end while
		}// end if
		else {
			for (l = 0; l < nRow; l++) {
				if (nofc[ l ] != UNUSED && C1(l) == CPOINT){
					this->C_[ l ] = CPOINT;
				}
			} // end for loop l
			break;
		} // end else
		this->C_[ max_index ] = CPOINT;
		nofc[ max_index ] = UNUSED;
		assigned_index++;

		// delete node from the list
		if (next_index[ max_index ] == LAST) { // if it is the last node
			if (prev_index[ max_index ] == FIRST) { // if it is the first node
				first_index[ max_lambda ] = UNUSED;
				while (first_index[ max_lambda ] == UNUSED) { // no node with max_lambda
					max_lambda--;
					if (max_lambda == 0)
						break;
				} // end while
			}// end if ( prev...)
			else { // Last index of list of size > 1
				next_index[ prev_index[ max_index ] ] = LAST;
			} // end else
		}// end if ( next... )
		else {
			if (prev_index[ max_index ] == FIRST) { // // if max_index is the first node
				first_index[ max_lambda ] = next_index[ max_index ];
				prev_index[ next_index[ max_index ] ] = FIRST;
			}// end if ( prev...)
			else { // index in the middle of list of size > 1
				prev_index[ next_index[ max_index ] ] = prev_index[ max_index ];
				next_index[ prev_index[ max_index ] ] = next_index[ max_index ];
			} // end else
		} // end else

		// Make pointers of max_index NULL
		prev_index[ max_index ] = UNUSED;
		next_index[ max_index ] = UNUSED;

		// Set unassigned points which strongly depend on max_index to be F point
		ts2iamax = RowST_[max_index];
		ts2iamaxp1 = RowST_[max_index+1];
		for (j = ts2iamax; j < ts2iamaxp1; j++) {
			ts2jaj = ColST_[j];
			nofcts2jaj = nofc[ts2jaj];
			if (nofcts2jaj > 0) {

				// Delete node jt(j)
				if (next_index[ ts2jaj ] == LAST) { // Last index of list
					if (prev_index[ ts2jaj ] == FIRST) { // First index of list
						first_index[ nofcts2jaj ] = UNUSED;
						while (first_index[ max_lambda ] == UNUSED) {
							max_lambda -= 1;
							if (max_lambda == 0)
								break;
						} // end while
					}// end if
					else { // Last index of list of size > 1
						next_index[ prev_index[ ts2jaj ] ] = LAST;
					}
				}// end if (next...)
				else {
					if (prev_index[ ts2jaj ] == FIRST) { // First index of list of size > 1
						first_index[ nofcts2jaj ] = next_index[ ts2jaj ];
						prev_index[ next_index[ ts2jaj ] ] = FIRST;
					} else {
						prev_index[ next_index[ ts2jaj ] ] = prev_index[ ts2jaj ];
						next_index[ prev_index[ ts2jaj ] ] = next_index[ ts2jaj ];
					}
				} // end else

				// Make pointers of max index NULL
				prev_index[ ts2jaj ] = UNUSED;
				next_index[ ts2jaj ] = UNUSED;

				// Assign jt(j) to be F point
				nofc[ ts2jaj ] = UNUSED;
				assigned_index++;

				// Check nbds of jt(j)
				s2iats2jaj = RowS_[ts2jaj];
				s2iats2jajp1 = RowS_[ts2jaj+1];
				for (k = s2iats2jaj; k < s2iats2jajp1; k++) {
					s2jak = ColS_[k];
					nofcs2jak = nofc[ s2jak ];
					if (nofcs2jak > 0) {
						// Delete js(k) from list of nofc(js(k))
						if (next_index[ s2jak ] == LAST) { // Last index of list
							if (prev_index[ s2jak ] == FIRST) { // First index of list
								first_index[ nofcs2jak ] = UNUSED;
							} else {
								next_index[ prev_index[ s2jak ] ] = LAST;
							}
						} else {
							if (prev_index[ s2jak ] == FIRST) {
								first_index[ nofcs2jak ] = next_index[ s2jak ];
								prev_index[ next_index[ s2jak ] ] = FIRST;
							} else {
								prev_index[ next_index[ s2jak ] ] = prev_index[ s2jak ];
								next_index[ prev_index[ s2jak ] ] = next_index[ s2jak ];
							}
						}

						// Increase the number of connection by 1
						nofc[ s2jak ]++;

						nofcs2jak = nofc[s2jak];
						// Update max_lambda
						if (nofcs2jak > max_lambda) {
							max_lambda = nofcs2jak;
						}
						// Insert index to new list
						if (first_index[ nofcs2jak ] == UNUSED) {
							first_index[ nofcs2jak ] = s2jak;
							prev_index[ s2jak ] = FIRST;
							next_index[ s2jak ] = LAST;
						} else {
							prev_index[ first_index[ nofcs2jak ] ] = s2jak;
							next_index[ s2jak ] = first_index[ nofcs2jak ];

							prev_index[ s2jak ] = FIRST;
							first_index[ nofcs2jak ] = s2jak;
						}
					} // end if (nofc...)
				} // end loop k
			} // end if
		} // end loop j
	} // end while
}

template <typename T>
void AGGCSN<T>::print(std::ostream& os) const{
	os << "Aggressive coarsening [npath = " << NPATH << ", nf = "
			<< this->nf_ <<", nc = " << this->nc_ <<"]";
}




#endif /* CSN_AGGCSN_HH_ */
