/*
 * amg_traits.hh
 *
 *  Created on: 2013. 8. 9.
 *      Author: parkmh
 */

#ifndef AMG_TRAITS_HH_
#define AMG_TRAITS_HH_
#include "../math/crs_matrix.hh"
#include "../math/cholesky.hh"
#include "relaxation.hh"
#include "csn_amgcsn.hh"
#include "csn_aggcsn.hh"
#include "interpolation_amgp.hh"
#include "interpolation_lramgp.hh"
#include "restriction_pt.hh"
#include "relaxation_gs.hh"
#include "relaxation_bgs.hh"
struct amg_tag{};
struct amg3d_tag{};

template<class Category, typename T = void>
struct amg_traits {};


template<typename T>
struct amg_traits<amg_tag,T>{
	typedef T 						datatype;
	typedef CRSMatrix<T> 		matrix;
	typedef AMGCSN<T> 			coarsen;
	typedef AMGCSN<T> 			fcoarsen;

	typedef AMGP<matrix> 		prolong;
	typedef AMGP<matrix> 		fprolong;
	typedef PT<matrix> 			shorten;
	typedef GS<matrix> 			smooth1;
	typedef GS<matrix> 			smooth2;
	typedef Cholesky<datatype> 	cstsolver;

	const static size_t r1 = 1;
	const static size_t r2 = 1;
	const static size_t mu = 1;
};

template<typename T>
struct amg_traits<amg3d_tag,T>{
	typedef T 						datatype;
	typedef CRSMatrix<T> 		matrix;
	typedef AMGCSN<T> 			coarsen;
	typedef AGGCSN<T> 			fcoarsen;

	typedef AMGP<matrix> 		prolong;
	typedef L2AMGP<matrix> 		fprolong;
	typedef PT<matrix> 			shorten;
	typedef GS<matrix> 			smooth1;
	typedef GS<matrix> 			smooth2;
	typedef Cholesky<datatype> 	cstsolver;

	const static size_t r1 = 1;
	const static size_t r2 = 1;
	const static size_t mu = 1;
};




#endif /* AMG_TRAITS_HH_ */
