/*
 * finite_element.hh
 *
 *  Created on: 2013. 12. 19.
 *      Author: parkmh
 */

#ifndef FINITE_ELEMENT_HH_
#define FINITE_ELEMENT_HH_
#include "../mesh/point.hh"
#include "node.hh"
template <class T, int N> class FiniteElement{
public:
	FiniteElement(){
		for (int i = 0; i < N; i++){
			vertex[i] = new Node<T>;
		}
	}// default constructor

	FiniteElement(Node<T>&, Node<T>&, Node<T>&);
	FiniteElement(FiniteElement<T,N>&);
	const FiniteElement<T,N>&
		operator=(FiniteElement<T,N>&);
	~FiniteElement();

	Node<T>& operator() (int i){
		return *(vertex[i]);
	}	// read/writhe ith vertex

	const Node<T>& operator[] (int i) const {
		return *(vertex[i]);
	} // real only ith vertex

	void resetIndices(){
		for (int i = 0; i < N; i++){
			vertex[i]->setIndex(-1);
		}
	}

	void indexing(int &count){
		for (int i = 0; i < N;i++){
			if (vertex[i]->getIndex()<0)
				vertex[i]->setIndex(count++);
		}
	}	// indexing the vertices

	friend std::ostream&
	operator<<(std::ostream& os, const FiniteElement &e){
		os << e[0];
		for (int i = 1; i < N; i++){
			os << ", " << e[i];
		}
		return os;
	}
protected:
	Node<T>* vertex[N];

};

template<class T, int N>
FiniteElement<T,N>::FiniteElement(
		Node<T>&a, Node<T>&b, Node<T>&c){
	vertex[0] = a.noSharingElements() ? new Node<T>(a) : &a;
	vertex[1] = a.noSharingElements() ? new Node<T>(b) : &b;
	vertex[2] = a.noSharingElements() ? new Node<T>(c) : &c;

	for (int i = 0; i < N; i++){
		vertex[i]->moreSharingElements();
	}
}	// constructor

template<class T, int N>
FiniteElement<T,N>::FiniteElement(FiniteElement<T,N>& e){
	for(int i = 0; i < N; i++){
		vertex[i] = e.vertex[i];
		vertex[i]->moreSharingElements();
	}
}	// copy constructor

template<class T, int N>
const FiniteElement<T,N>&
	FiniteElement<T,N>::operator =(FiniteElement<T,N>&e){
	if (this != &e){
		for (int i = 0; i < N; i++){
			if (vertex[i]->lessSharingElements()){
				delete vertex[i];
			}
		}
		for (int i = 0; i < N; i++){
			vertex[i] =  e.vertex[i];
			vertex[i]->moreSharingElements();
		}
	}
	return *this;
}	// assignment operator

template <class T, int N>
FiniteElement<T,N>::~FiniteElement(){
	for (int i= 0; i < N; i++){
		if (vertex[i]->lessSharingElements()) delete vertex[i];
	}	// destructor
}

template <class T, int N>
int operator<(const Node<T>&n, const FiniteElement<T,N>&e){
	for (int i = 0; i < N; i++){
		if (&n == &(e[i])) return i+1;
	}
	return 0;
}

typedef FiniteElement<Pd2,3> Triangle;
typedef FiniteElement<Pd2,4> Quadrilateral;
typedef FiniteElement<Pd3,4> Tetrahedron;

#endif /* FINITE_ELEMENT_HH_ */
