/*
 * mlmc_test.cpp
 *
 *  Created on: 2014. 1. 11.
 *      Author: parkmh
 */

#include "mc_traits.hh"
#include "mlmc_traits.hh"
#include "../../montecarlo/mlmc.hh"
#include "../../util/timer.hh"

int main(){
	typedef mlmc1d_tag mlmc_tag;
	typedef mlmc_traits<mlmc_tag,double> traits;
	typedef typename traits::coarsest_mc	coarsest_mc;
	typedef typename traits::mc_tag mc_tag;
	typedef typename mc_traits<mc_tag,double>::discretization discretization;
	typedef typename discretization::pos pos;
	typedef typename discretization::N N;


	N n = 8;
	N nd, nh;
	nh[0] = n[0]/2;
	nh[1] = n[1]/2;
	nd[0] = n[0]*2;
	nd[1] = n[1]*2;
	size_t level = 6;
	pos start, end, hh;
	start = 0.;
	end = 1.0;

	size_t nsamp = 5000;

	Timer timer;
	timer.tic();

	typedef double T;
	typedef mlmc_traits<mlmc_tag,T> traits;
	typedef typename traits::mc_tag mc_tag;
	typedef typename traits::coarsest_mc_base	coarsest_mc_base;
	typedef typename traits::twolevel_mc_base twolevel_mc_base;
	typedef typename traits::coarsest_mc coarsest_mc;
	typedef typename traits::twolevel_mc twolevel_mc;
	typedef typename mc_traits<mc_tag,T>::rfgenerator rfgenerator;
	typedef typename mc_traits<mc_tag,T>::discretization discretization;
	typedef typename discretization::pos pos;
	typedef typename discretization::N N;

	coarsest_mc_base coarsest_mc_base_;
	twolevel_mc_base *twolevel_mc_base_;
	coarsest_mc		coarsest_mc_;
	twolevel_mc		*twolevel_mc_;

	discretization * disc_;
	rfgenerator * rfg_;

	rfg_ = new rfgenerator[level];
	disc_ = new discretization[level];
	twolevel_mc_base_ = new twolevel_mc_base[level-1];
	twolevel_mc_ = new twolevel_mc[level-1];


	disc_[0].init(start,end,nh);
	for(size_t l = 0; l < level; l++){
		std::cout << "N : " << n << std::endl;
		hh[0] = 0.5*(end[0] - start[0])/(double)n[0];
		hh[1] = 0.5*(end[1] - start[1])/(double)n[1];


		rfg_[l+1].init(start,end,nd,hh);
		disc_[l+1].init(start,end,n);
		twolevel_mc_base_[l].init(disc_[l+1], disc_[l],rfg_[l+1]);

		twolevel_mc_[l].init(twolevel_mc_base_[l],nsamp);

		std::cout << "E[Qh] : " << twolevel_mc_[l].meanQ() << std::endl;
		std::cout << "V[Qh] : " << twolevel_mc_[l].varQ() << std::endl;
		std::cout << "E[Q2h] : " << twolevel_mc_[l].meanQc() << std::endl;
		std::cout << "V[Q2h] : " << twolevel_mc_[l].varQc() << std::endl;
		std::cout << "E[Yh] : " << twolevel_mc_[l].meanY() << std::endl;
		std::cout << "V[Yh] : " << twolevel_mc_[l].varY() << std::endl << std::endl;
		n *= 2;
		nd *= 2;
	}


	delete [] rfg_;
	delete [] disc_;
	delete [] twolevel_mc_;
	delete [] twolevel_mc_base_;
	timer.toc();

}




