/*
 * qoi_pressure2.hh
 *
 *  Created on: 2014. 3. 18.
 *      Author: parkmh
 */

#ifndef QOI_PRESSURE2_HH_
#define QOI_PRESSURE2_HH_

template <int dim, typename DISC>
struct qoi_pressure2{
	typedef typename DISC::datatype datatype;
	datatype operator()(const DISC& disc, const NumVec<datatype>& u, const NumVec<datatype>& k) const{
		datatype qoi = 0.0;
		size_t nx = disc.nx();
		size_t nxh = nx/2;

		if (dim == 1){
			qoi = (u[nxh] + u[nxh-1])/2;
		} else if (dim == 2){
			size_t ny = disc.ny();
			size_t nyh = ny/2;

			size_t index;
			index = nx*(nyh-1)+nxh-1;
			qoi += u[index];
			index++;
			qoi += u[index];
			index = nx*nyh+nxh-1;
			qoi += u[index];
			index++;
			qoi += u[index];

			qoi /= 4.0;
		} else if (dim == 3){
			size_t ny = disc.ny();
			size_t nyh = ny/2;
			size_t nz = disc.nz();
			size_t nzh = nz/2;
			datatype hz = disc.hz();
			size_t index;
			size_t nx1 = nx-1;

			index = (nxh-1)+nx*((nyh-1)+ny*(nzh-1));
			qoi += u[index];
			index++;
			qoi += u[index];

			index = (nxh-1)+nx*((nyh)+ny*(nzh-1));
			qoi += u[index];
			index++;
			qoi += u[index];

			index = (nxh-1)+nx*((nyh-1)+ny*(nzh));
			qoi += u[index];
			index++;
			qoi += u[index];

			index = (nxh-1)+nx*((nyh)+ny*(nzh));
			qoi += u[index];
			index++;
			qoi += u[index];

			qoi /= 8.0;

		}
		return qoi*qoi;
	}
};




#endif /* QOI_PRESSURE2_HH_ */
