/*
 * qoi_outflux.hh
 *
 *  Created on: 2013. 8. 20.
 *      Author: parkmh
 */

#ifndef QOI_OUTFLUX_HH_
#define QOI_OUTFLUX_HH_

template <int dim, typename DISC>
struct qoi_outflux{
	typedef typename DISC::datatype datatype;
	datatype operator()(const DISC& disc, const NumVec<datatype>& u, const NumVec<datatype>& k) const{
		datatype qoi = 0.0;
		size_t nx = disc.nx();
		datatype hx = disc.hx();

		if (dim == 1){
			qoi = k[nx-1]*u[nx-1]*2.0/hx;
		} else if (dim == 2){
			size_t ny = disc.ny();
			datatype hy = disc.hy();
			size_t index;
			for ( size_t i = 0; i < ny;i++)
			{
				index = (i+1) * nx - 1;
				qoi += k[index] * u[index]*2.0*hy/hx;
			}
		} else if (dim == 3){
			size_t ny = disc.ny();
			datatype hy = disc.hy();
			size_t nz = disc.nz();
			datatype hz = disc.hz();
//			std::cout << "ny " << ny << ", nz " << nz << std::endl;
//			std::cout << "hx " << hy << ", hz " << hz << std::endl;
			size_t index;
			size_t nx1 = nx-1;

			for ( size_t i = 0; i < nz;i++)
			{
				for ( size_t j = 0; j < ny; j++){
					index = nx1 + nx*(j+ny*i);
//					std::cout << i << ", " << j << ", index " << index << std::endl;
					qoi += k[index] * u[index]*2.0*hy*hz/hx;
				}
			}
//			abort();

		}
		return qoi;
	}
};




#endif /* QOI_OUTFLUX_HH_ */
