/*
 * restriction_pt.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */

#ifndef RESTRICTION_PT_HH_
#define RESTRICTION_PT_HH_

#include "restriction.hh"

template <class CRSMAT>
class PT:public Restriction<CRSMAT>{
public:
	typedef typename CRSMAT::data_type data_type;
	PT(){};
	PT(const CRSMAT&,const INTP<CRSMAT>& );
	void init(const CRSMAT&, const INTP<CRSMAT>&);
	void shorten(NumVec<data_type> &,const  NumVec<data_type> &) const;
	void print(std::ostream & ) const;
};

template <class CRSMAT>
PT<CRSMAT>::PT(const CRSMAT& a,  const INTP<CRSMAT>& p){
	init(a,p);
}
template <class CRSMAT>
void PT<CRSMAT>::init(const CRSMAT& a, const INTP<CRSMAT>& p){
	this->PT_ = p()->transpose();
}
template <class CRSMAT>
void PT<CRSMAT>::shorten(NumVec<data_type> &x2h,const  NumVec<data_type> &xh) const{
	axey<data_type>(this->PT_,xh,x2h);
}

template <class CRSMAT>
void PT<CRSMAT>::print(std::ostream& os) const {
	os << "Transpose of P [nf = "
			<< this->PT_.col() <<", nc = " << this->PT_.row() <<"]";
}

#endif /* RESTRICTION_PT_HH_ */
