/*
 * realxation_factory.hh
 *
 *  Created on: 2013. 9. 9.
 *      Author: parkmh
 */

#ifndef REALXATION_FACTORY_HH_
#define REALXATION_FACTORY_HH_
#include "relaxation.hh"
#include <string>
#include <map>
template <class CRSMAT>
class RelaxationFactory{
public:
	typedef Relaxation<CRSMAT> *(*CreateCallback)();
	static void RegisterRelaxation(const std::string &type, CreateCallback cb);
	static void UnRegisterRelaxation(const std::string &type);
	static Relaxation *CreateRelaxation(const std::string & type);

private:
	typedef std::map<std::string, CreateCallback> CallbackMap;
	static CallbackMap mRelaxations;
};

// instantiate the static variable in RelaxationFactory
template <class CRSMAT> RelaxationFactory<CRSMAT>::CallbackMap RelaxationFactory<CRSMAT>::mRelaxations;

template <class CRSMAT> RelaxationFactory<CRSMAT>::RegisterRelaxation(const std::string &type, CreateCallback cb){
	mRelaxations[type] = cb;
}





#endif /* REALXATION_FACTORY_HH_ */
