/*
 * csn.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */

/*
 * Changelog
 * v.0.1 Added coarsening base in csn.hh.
 *
 */
#ifndef CSN_HH_
#define CSN_HH_

#include "../util/config.hh"
#include "../math/crs_matrix.hh"
#include <vector>
#include <cmath>
#include <iostream>

template <typename T>
class CSN{
public:
	typedef T datatype;
	CSN() {A_ = NULL, nf_ = 0; nc_ = 0;};
	virtual void init(const CRSMatrix<T> &) = 0;
	virtual ~CSN() {};
	virtual void print(std::ostream&) const = 0;
	virtual const size_t& rows(size_t n) const = 0;
	virtual const size_t& cols(size_t n) const = 0;
	const bool& operator() (size_t n) const{return C_[n]; }
	double ratio() const {return (double)nc_/(double)nf_;}
	size_t nf() const		{return nf_;}
	size_t nc() const 	{return nc_;}
	void compute_nc();

	friend std::ostream&
	operator<<(std::ostream& os, const CSN& csn){
		csn.print(os);
		return os;
	}
protected:
	const CRSMatrix<T> *A_;
	NumVec<bool> C_;
	size_t nf_;
	size_t nc_;
};

template <typename T>
void CSN<T>::compute_nc(){
	nc_ = 0;
	for (size_t i = 0; i < nf_; i++)
		if (C_[i]) nc_++;
}
#endif /* CSN_HH_ */
