/*
 * fvm_traits.hh
 *
 *  Created on: 2013. 8. 15.
 *      Author: parkmh
 */

#ifndef FVM_TRAITS_HH_
#define FVM_TRAITS_HH_

#define DIRICHLET 1
#define NEUMANN   0
#include "../cem/cem_traits.hh"
#include "constantcoeff.hh"
#include "../cem/cem.hh"
#include "../util/config.hh"
#include <functional>

struct fvm1d_tag{};
struct fvm2d_tag{};
struct fvm3d_tag{};

template <class Category, typename = void>
struct fvm_traits {};

template <int dim, typename T>
struct BNDFUN{
	T operator()(const Point<dim,T>& x){
		if (x[0] == 0.0) return 1.0;
		if (x[0] == 1.0) return 0.0;

		return 0.0;
	}
};

template <int dim, typename T>
struct forceterm{
	T operator()(const Point<dim,T>& x){
		return 0.0;
	}
};


template <class T>
struct fvm_traits<fvm1d_tag,T>{
	typedef T									datatype;
	static const int dim = 1;
	static const int x0 = DIRICHLET;
	static const int x1 = DIRICHLET;
	static const int y0 = NEUMANN;
	static const int y1 = NEUMANN;
	static const int z0 = NEUMANN;
	static const int z1 = NEUMANN;
	typedef BNDFUN<dim,T> boundary;
	typedef forceterm<dim,T> force;
};

template <class T>
struct fvm_traits<fvm2d_tag,T>{
	typedef T		datatype;
	static const int dim = 2;
	static const int x0 = DIRICHLET;
	static const int x1 = DIRICHLET;
	static const int y0 = NEUMANN;
	static const int y1 = NEUMANN;
	static const int z0 = NEUMANN;
	static const int z1 = NEUMANN;
	typedef BNDFUN<dim,T> boundary;
	typedef forceterm<dim,T> force;
};

template <class T>
struct fvm_traits<fvm3d_tag,T>{
	typedef T		datatype;
	typedef CEM<cem3d_tag ,T> 	coeff;
	static const int dim = 3;
	static const int x0 = DIRICHLET;
	static const int x1 = DIRICHLET;
	static const int y0 = NEUMANN;
	static const int y1 = NEUMANN;
	static const int z0 = NEUMANN;
	static const int z1 = NEUMANN;
	typedef BNDFUN<dim,T> boundary;
	typedef forceterm<dim,T> force;
};

#endif /* FVM_TRAITS_HH_ */
