/*
 * node.hh
 *
 *  Created on: 2013. 12. 19.
 *      Author: parkmh
 */
#ifndef NODE_HH_
#define NODE_HH_

#include <iostream>
template <class T> class Node{
public:
	Node(const T& loc = 0., int ind = -1, int sharing = 0)
	: location(loc), index(ind), sharingCells(sharing){
	}	// constructor

	Node(const Node& n):location(n.location), index(n.index), sharingCells(sharingCells){
	}	// copy constructor

	const Node& operator=(const Node&);

	~Node(){}	// destructor

	const T& operator() () const {
		return location;
	}	// read the location

	int getIndex() const {
		return index;
	}	// get index

	void setIndex(int i) {
		index = i;
	}	// set index

	int getSharingCells() const{
		return sharingCells;
	}	// read number of Cells that share this node

	void moreSharingCells() {
		sharingCells++;
	}	// increase number of Cells that share this node

	int lessSharingCells(){
		return sharingCells ? !(--sharingCells) : 1;
	}	// decrease number of Cells that share this node

	int noSharingCells() const {
		return !sharingCells;
	}	// indicate a dangling node

	friend std::ostream&
	operator<<(std::ostream& os, const Node &n){
		os << n() << " index=" << n.getIndex() << ", "
			<< n.getSharingCells() << " sharing Cells";
		return os;
	}
private:
	T location;
	int index;
	int sharingCells;

};

template <class T>
const Node<T>& Node<T>::operator =(const Node<T>& n){
	if (this!= n){
		location = n.location;
		index = n.index;
		sharingCells = n.sharingCells;
	}
	return *this;
}



#endif /* NODE_HH_ */
