/*
 * linked_list.hpp
 *
 *  Created on: 2013. 12. 23.
 *      Author: parkmh
 */

#ifndef LINKED_LIST_HPP_
#define LINKED_LIST_HPP_

#include <iostream>
#include <cmath>

template <class T> class LinkedList{
public:
	LinkedList() : next(0){
	}	// default constructor

	LinkedList(const T&t, LinkedList* N = 0)
		: item(t), next(N){
	}	// constructor

	const T& operator() () const {
		return item;
	}	// read item field

	const LinkedList*  readNext() const {
		return next;
	}

	const LinkedList& operator= (const LinkedList&);
	LinkedList(const LinkedList& l): item(l()),
			next(l.next ? new LinkedList(*(l.next)):0){
	} 	// copy constructor

	~LinkedList() {
		delete next;
		next = 0;
	}	// destructor

	LinkedList& last(){
		return next ? next->last() : *this;
	}	// last item

	int length() const {
		return next? next->length() + 1 : 1;
	}	// number of items

	void append(const T&t){
		last().next = new LinkedList(t);
	}	// append item

	void insertNextItem(T&t){
		next = new LinkedList(t,next);
	}	// insert item in second place

	void insertFirstItem(T&t){
		next = new LinkedList(item,next);
		item = t;
	}	// insert item at the beginning

	void dropNextItem();
	void dropFirstItem();
	void truncateItems(double);
	const LinkedList& operator+=(LinkedList&);
	LinkedList& order(int);

	friend std::ostream&
	operator<<(std::ostream& os, const LinkedList &l){
		os << l();
		if (l.readNext()){
			os << "=>" << *l.readNext();
		}
		return os;
	}
protected:
	T item;
	LinkedList * next;
};


template <class T>
const LinkedList<T>& LinkedList<T>::operator=(const LinkedList<T>&L){
	if (this != &L){
		item = L();
		if (next){
			if (L.next)
				*next = *L.next;
			else {
				delete next;
				next = 0;
			}
		}
		else
			if (L.next)
				next = new LinkedList(*L.next);
	}
	return *this;
}	// assignment operator

template <class T>
void LinkedList<T>::dropNextItem(){
	if (next){
		if (next->next){
			LinkedList<T>* keep = next;
			next = next->next;
			keep->item.~T();
		}
		else {
			delete next;
			next = 0;
		}
	}
	else
		std::cout << "error: cannot drop nonexisting next item" << std::endl;
}	// drop the second item from the connected list

template <class T>
void LinkedList<T>::dropFirstItem(){
	if (next){
		item = next->item;
		dropNextItem();
	}
	else
		std::cout << "error: cannot drop first item; no next." << std::endl;
}	// drop the first item in the connected list

template<class T>
void LinkedList<T>::truncateItems(double threshold){
	if (next){
		if (next&&(abs(item.getValue())<= threshold ))
			dropFirstItem();
	}
}	// truncate certain items

template <class T>
const LinkedList<T>& LinkedList<T>::operator +=(LinkedList<T>&L){
	LinkedList<T>* runner = this;
	LinkedList<T>* Lrunner = &L;

	if (L.item < item){
		insertFirstItem(L.item);
		Lrunner = L.next;
	}
	for (; runner->next; runner = runner->next){
		if (Lrunner&&(Lrunner->item == runner->item)){
			runner->item += Lrunner->item;
			Lrunner = Lrunner->next;
		}
		for (; Lrunner&&(Lrunner->item < runner->next->item);
				Lrunner = Lrunner->next){
			runner->insertNextItem(Lrunner->item);
			runner = runner->next;
		}
	}

	if (Lrunner&&(Lrunner->item == runner->item)){
		runner->item += Lrunner->item;
		Lrunner = Lrunner->next;
	}
	if (Lrunner)
		runner->next = new LinkedList<T>(*Lrunner);
	return *this;
}	// merge two connected list while preserving order as required.


template<class T>
LinkedList<T>& LinkedList<T>::order(int length){
	if (length>1){
		LinkedList<T>* runner = this;
		for (int i = 0; i < length/2-1; i++){
			runner = runner->next;
		}
		LinkedList<T>* second = runner-> next;
		runner->next = 0;
		order(length/2);
		*this += second->order(length=length/2);
	}
	return *this;
}




#endif /* LINKED_LIST_HPP_ */
