/*
 * connected_list.hh
 *
 *  Created on: 2013. 12. 19.
 *      Author: parkmh
 */

#ifndef CONNECTED_LIST_HH_
#define CONNECTED_LIST_HH_
#include <iostream>
#include <cmath>

template <class T> class ConnectedList{
public:
	ConnectedList() : next(0){
	}	// default constructor

	ConnectedList(const T&t, ConnectedList* N = 0)
		: item(t), next(N){
	}	// constructor

	const T& operator() () const {
		return item;
	}	// read item field

	const ConnectedList*  readNext() const {
		return next;
	}

	const ConnectedList& operator= (const ConnectedList&);
	ConnectedList(const ConnectedList* l): item(l()),
			next(l->next ? new ConnectedList(*(l->next)):0){
	} 	// copy constructor

	~ConnectedList() {
		delete next;
		next = 0;
	}	// destructor

	ConnectedList& last(){
		return next ? next->last() : *this;
	}	// last item

	int length() const {
		return next? next->length() + 1 : 1;
	}	// number of items

	void append(const T&t){
		last().next = new ConnectedList(t);
	}	// append item

	void insertNextItem(const T&t){
		next = new ConnectedList(t,next);
	}	// insert item in second place

	void insertFirstItem(const T&t){
		next = new ConnectedList(item,next);
		item = t;
	}	// insert item at the beginning

	void dropNextItem();
	void dropFirstItem();
	void truncateItems(double);
	const ConnectedList& operator+=(ConnectedList&);
	ConnectedList& order(int);

	friend std::ostream&
	operator<<(std::ostream& os, const ConnectedList &l){
		os << l();
		if (l.readNext()){
			os << "=>" << *l.readNext();
		}
		return os;
	}
protected:
	T item;
	ConnectedList * next;
};


template <class T>
const ConnectedList<T>& ConnectedList<T>::operator =(const ConnectedList<T>&L){
	if (this != &L){
		item = L();
		if (next){
			if (L.next)
				*next = *L.next;
			else {
				delete next;
				next = 0;
			}
		}
		else
			if (L.next)
				next = new ConnectedList(*L.next);
	}
	return *this;
}	// assignment operator

template <class T>
void ConnectedList<T>::dropNextItem(){
	if (next){
		if (next->next){
			ConnectedList<T>* keep = next;
			next = next->next;
			keep->item.~T();
		}
		else {
			delete next;
			next = 0;
		}
	}
	else
		std::cout << "error: cannot drop nonexisting next item" << std::endl;
}	// drop the second item from the connected list

template <class T>
void ConnectedList<T>::dropFirstItem(){
	if (next){
		item = next->item;
		dropNextItem();
	}
	else
		std::cout << "error: cannot drop first item; no next." << std::endl;
}	// drop the first item in the connected list

template<class T>
void ConnectedList<T>::truncateItems(double threshold){
	if (next){
		if (next&&(abs(item.getValue())<= threshold ))
			dropFirstItem();
	}
}	// truncate certain items

template <class T>
const ConnectedList<T>& ConnectedList<T>::operator +=(ConnectedList<T>&L){
	ConnectedList<T>* runner = this;
	ConnectedList<T>* Lrunner = &L;

	if (L.item < item){
		insertFirstItem(L.item);
		Lrunner = L.next;
	}
	for (; runner->next; runner = runner->next){
		if (Lrunner&&(Lrunner->item == runner->item)){
			runner->item += Lrunner->item;
			Lrunner = Lrunner->next;
		}
		for (; Lrunner&&(Lrunner->item < runner->next->item);
				Lrunner = Lrunner->next){
			runner->insertNextItem(Lrunner->item);
			runner = runner->next;
		}
	}

	if (Lrunner&&(Lrunner->item == runner->item)){
		runner->item += Lrunner->item;
		Lrunner = Lrunner->next;
	}
	if (Lrunner)
		runner->next = new ConnectedList<T>(*Lrunner);
	return *this;
}	// merge two connected list while preserving order as required.


template<class T>
ConnectedList<T>& ConnectedList<T>::order(int length){
	if (length>1){
		ConnectedList<T>* runner = this;
		for (int i = 0; i < length/2-1; i++){
			runner = runner->next;
		}
		ConnectedList<T>* second = runner-> next;
		runner->next = 0;
		order(length/2);
		*this += second->order(length=length/2);
	}
	return *this;
}
#endif /* CONNECTED_LIST_HH_ */
