/*
 * mlmc_traits.hh
 *
 *  Created on: 2013. 8. 21.
 *      Author: parkmh
 */

#ifndef MLMC_TRAITS_HH_
#define MLMC_TRAITS_HH_

#include "../../montecarlo/one_level_mc.hh"
#include "../../montecarlo/two_level_mc.hh"
#include "../../montecarlo/montecarlo.hh"

struct mlmc1d_tag{};
struct mlmc2d_tag{};
struct mlmc3d_tag{};


template <class Category, typename = void>
struct mlmc_traits{};

template <class T>
struct mlmc_traits<mlmc1d_tag,T>{
	typedef T datatype;
	static const int dim = 1;
	static const int maxlevel = 12;
	static const int rfactor = 2;
	typedef mc1d_tag 	mc_tag;
	typedef OneLevelMC<mc_tag,T> coarsest_mc_base;
	typedef MC<coarsest_mc_base> coarsest_mc;
	typedef TwoLevelMC<mc_tag,T> twolevel_mc_base;
	typedef MC<twolevel_mc_base> twolevel_mc;
};

template <class T>
struct mlmc_traits<mlmc2d_tag,T>{
	static const int maxlevel = 12;
	static const int dim = 2;
	static const int rfactor = 4;
	typedef T datatype;
	typedef mc2d_tag 	mc_tag;
	typedef OneLevelMC<mc_tag,T> coarsest_mc_base;
	typedef MC<coarsest_mc_base> coarsest_mc;
	typedef TwoLevelMC<mc_tag,T> twolevel_mc_base;
	typedef MC<twolevel_mc_base> twolevel_mc;
};

template <class T>
struct mlmc_traits<mlmc3d_tag,T>{
	typedef T datatype;
	static const int dim = 3;
	static const int maxlevel = 7;
	static const int rfactor = 8;
	typedef mc3d_tag 	mc_tag;
	typedef OneLevelMC<mc_tag,T> coarsest_mc_base;
	typedef MC<coarsest_mc_base> coarsest_mc;
	typedef TwoLevelMC<mc_tag,T> twolevel_mc_base;
	typedef MC<twolevel_mc_base> twolevel_mc;

};




#endif /* MLMC_TRAITS_HH_ */
