/*
 * observation.hh
 *
 *  Created on: 2013. 9. 22.
 *      Author: parkmh
 */

#ifndef OBSERVATION_HH_
#define OBSERVATION_HH_
#include "../mesh/point.hh"
#include "../math/numvec.hh"
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <iomanip>

template <int dim>
class Observation{
	typedef Point<dim,double> P;
private:
	static bool instanceFlag;
	static Observation *observation;
	Observation(){ };
	static std::vector<P> 		location_;
	static NumVec<double> 	value_;
	static std::vector<std::string> name_;
	static size_t nobservation_;
	static double mu1_;
	static double mu2_;
public:
	static Observation* getInstance();
	void load(const char *);
	size_t nobsv() const {return nobservation_;}
	P loc(size_t i) const {return location_[i];}
	friend std::ostream&
	operator<<(std::ostream& os, const Observation &rhs){
		int namew = 10;
		int valuew = 5;
		for(size_t i = 0; i < nobservation_; i++){
			os << "[" << std::setw(3) << i+1<< "] " << std::setw(namew)<< name_[i] << " : "
				<< std::setw(valuew)<<value_[i] << ", "
				<< location_[i] <<  std::endl;
		}
		return os;
	}
	double mu1() const {return mu1_;}
	double mu2() const {return mu2_;}
	~Observation(){ instanceFlag = false; }
	NumVec<double> returnOberservation() const {return value_;}
};

template <int dim>
bool Observation<dim>::instanceFlag = false;

template <int dim>
Observation<dim>* Observation<dim>::observation = NULL;

template <int dim>
size_t Observation<dim>::nobservation_ = 0;
template <int dim>
double Observation<dim>::mu1_ = .0;
template <int dim>
double Observation<dim>::mu2_ = .0;
template <int dim>
NumVec<double> Observation<dim>::value_ = NumVec<double>();

template <int dim>
std::vector<std::string> Observation<dim>::name_ = std::vector<std::string>();

template <int dim>
std::vector< Point<dim,double> > Observation<dim>::location_ = std::vector< Point<dim,double > >(0.0);

template <int dim>
Observation<dim>* Observation<dim>::getInstance(){
	if (!instanceFlag){
		observation = new Observation();
		instanceFlag = true;
		return observation;
	}
	else{
		return observation;
	}
}

template <int dim>
void Observation<dim>::load(const char* filename){
	std::ifstream load;
	load.open(filename,std::ios::in);
	if (!load){
		std::cerr << "\n" ;
		std::cerr << "LOAD - Fatal error!\n";
		std::cerr << " Could not open the file: \"" << filename << "\"\n";
		abort();
	}
	load >> Observation<dim>::nobservation_;
	load >> Observation<dim>::mu1_;
	load >> Observation<dim>::mu2_;
	load.precision(16);
	P location = 0.0;
	double value = 0.0;
	std::string name;
	value_.resize(nobservation_);
	for (size_t i = 0; i < nobservation_; i++){
		for (int j = 0; j < dim; j++){
			load >> location[j];
		}
		location_.push_back(location);
		load >> value;
		value_[i] = value;
		load >> name;
		name_.push_back(name);
	}
	load.close();
}
#endif /* OBSERVATION_HH_ */
