/*
 * covariance_functions.hh
 *
 *  Created on: 2013. 12. 15.
 *      Author: Minho Park
 */

#ifndef COVARIANCE_FUNCTIONS_HH_
#define COVARIANCE_FUNCTIONS_HH_
#include <cmath>
#include <tr1/cmath>


template <typename T>
struct ExpCov{
	const T sigma2 = 1.0;
	const T lambda = 0.3;
	T operator()(const T& r) {
		return sigma2*(T)exp(-r/lambda);
	}
	std::string Description() const {
		std::ostringstream convert1, convert2;
		convert1 << sigma2;
		convert2 << lambda;
		std::string description = "Exponential [sigma2 = "
				                 + convert1.str() + ", lambda = " + convert2.str() + "]";
		return description;
	}
};


template <typename T>
struct GaussCov{
	const T sigma2 = 1.0;
	const T lambda = 0.3;
	T operator()(const T& r) {
		return sigma2*(T)exp(-r*r/(lambda*lambda));
	}
	std::string Description() const {
		std::ostringstream convert1, convert2;
		convert1 << sigma2;
		convert2 << lambda;
		std::string description = "Gaussian [sigma2 = "
				                 + convert1.str() + ", lambda = " + convert2.str() + "]";
		return description;
	}
};


template <typename T>
struct MaternCov{
	const T nu = 1.5;
	const T rho = .3;
	const T sigma2 = 1;
	T operator()(const T& r) {
		T phi = std::sqrt(2*nu)*r/rho;
		if (phi == 0){
			return sigma2;
		} else {
			if (nu == 0.5){
				return sigma2*(T)exp(-r/rho);
			} else {
				return sigma2/(tgamma(nu)*std::pow(2.0,nu-1))*std::pow(phi,nu)*std::tr1::cyl_bessel_k(nu,phi);
			}
		}
	}

	std::string Description() const {
		std::ostringstream convert1, convert2, convert3;
		convert1 << sigma2;
		convert2 << nu;
		convert3 << rho;
		std::string description = "Matern [sigma2 = "
				                 + convert1.str() + ", nu = " + convert2.str()  + ", rho = " + convert3.str()+ "]";
		return description;
	}
};


#endif /* COVARIANCE_FUNCTIONS_HH_ */
