/*
 * triangle.hh
 *
 *  Created on: 2013. 8. 19.
 *      Author: parkmh
 */

#ifndef TRIANGLE_HH_
#define TRIANGLE_HH_

#include "point3.hh"
#include <cmath>
#include "GL/freeglut.h"

template <typename T>
class Triangle{
private:
	static float EPS;
	const Point3<T> *a_, *b_, *c_;

public:
	Triangle(const Point3<T>& a, const Point3<T>& b, const Point3<T>& c)
		: a_(&a), b_(&b), c_(&c)
	{}
	~Triangle() {}
	T area() const;
	Vec3<T> normal() const;
	void draw() const;
};

template <typename T>
T Triangle<T>::area() const {
	return (normal().norm()*0.5);
}


template <typename T>
Vec3<T> Triangle<T>::normal() const {
	return cross<T>(*b_-*a_,*c_-*a_);
}

template <typename T>
void Triangle<T>::draw() const {
	std::cout << "triangle" << std::endl;
	glBegin(GL_TRIANGLES);
		glVertex4f(a_->x(), a_->y(),a_->z(),a_->h());
		glVertex4f(b_->x(), b_->y(),b_->z(),b_->h());
		glVertex4f(c_->x(), c_->y(),c_->z(),c_->h());
	glEnd();
}
#endif /* TRIANGLE_HH_ */
