/*
 * This file is an example to see how to use the circulant embedding methods.
 * In order to change some parameters such as correlation length, and varaince,
 * see CEM_TRAINTS.HH file for more detail.
 * If you have any question, please send an email to min.park@nottingham.ac.uk.
 */
#include "../cem/cem_traits.hh"
#include "../cem/cem.hh"
#include <iostream>
#include <functional>
#include <fstream>


int main(){
	typedef CEM<cem1d_tag,double> cemtype;
	typename cemtype::pos start, end, h;
	typename cemtype::N sample_pts;
	const int dim = cemtype::dim;

	int n = 8;		// the number of sampling points in each direction
	start = 0.0;		// start[0] = -1.0;
	end = 1.0;
	sample_pts = n;
	h = 1.0/(double)n;
	cemtype cem;
	cem.init(start,end,sample_pts,h);


	NumVec<double> z;
	cem.generate(z);

	std::cout << z << std::endl;
}

