# Makefile.inc

# C/C++ compiler
CC			= gcc
CXX			= g++
MPICXX 	= mpiCC
MPICC		= mpicc
C11FLAG 	= -std=c++11
CPPFLAG	+= $(C11FLAG)
# Bash commands
AR			= ar
RANLIB 	= ranlib
RM  		= rm
MV			= mv
MKDIR 		= mkdir -p
CP 			= cp
CAT			= cat
ECHO 		= echo
SED			= sed
GREP		= grep
TAR			= tar
# Libraries
FFTW		= -lfftw3 
FFTWMPI 	= -lfftw3_mpi -lfftw3 -lm
OPENGL 	= -lglut -lGL -lGLU

# Doxygen
DOXYGEN		= doxygen
DOXYGENFILE 	= numeracy.conf 

# OpenMP
USE_OPENMP = NO

# Date and Today command
DATE=$(shell date +[%Y.%m.%d])
TODAY=$(shell date +%Y.%m.%d)

# Compiler Flags
MODE = DEBUGMODE
ifeq ($(MODE),DEBUGMODE)
PROJFLAGS = -O2 -g -Wall
endif
ifeq ($(MODE),RELEASEMODE)
PROJFLAGS = -O3
endif

# Valgrid (MEMCHECK|CALLGRIND|HELGRIND)
VALMODE  = MEMCHECK
#VALMODE = CALLGRIND
#VALMODE = HELGRIND


VALGRIND = valgrind
VALLOG	= profile
ifeq ($(VALMODE),MEMCHECK)
VALFLAGS = --tool=memcheck
VALFLAGS += -v --leak-check=full 
VALFLAGS += --track-origins=yes
#VALFLAGS += --show-reachable=yes
VALFLAGS += --log-file=$(VALLOG)
endif
ifeq ($(VALMODE),CALLGRIND)
VALFLAGS = --tool=callgrind
#VALFLAGS += --separate-threads=yes
endif
ifeq ($(VALMODE),HELGRIND)
VALFLAGS = --tool=helgrind
VALFLAGS += --read-var-info=yes
VALFLAGS += --log-file=$(VALLOG)
endif


# CHANGELOG
CHANGELOG 	= Changelog
EMAIL 		= min.park@nottingham.ac.uk
VERHIST	= v.0.1
AUTHOR 	= Minho Park
.SILENT:
