module Roots where


import           E8                  (Vector,gen,posRoots,inp)

import           Control.Applicative ((<$>))
import           Control.Monad       (when)
import           Data.Traversable    (for)
import           Data.List           (genericLength)
import qualified Number.Peano as Peano
import           System.Environment  (getArgs)
import           System.IO           (hSetBuffering,BufferMode(LineBuffering),stdout)


main :: IO ()
main = do
  r : maxD : _ <- map read <$> getArgs
  hSetBuffering stdout LineBuffering
  when (odd r) $ error "Error: number of orthogonal roots must be even."
  let p = fromInteger $ r `div` 2
  (>> return ()) . for [1 .. fromInteger maxD] $ \ d -> do
    putStr $ "d = " ++ show d ++ ": "
    let
      special = filter (apt p) (gen d)
    case special of
      []    -> putStrLn $ "no"
      _ : _ -> putStrLn $ "yes"

-- Verify whether a given vector is orthogonal to exactly 2*p roots.
apt :: Peano.T -> Vector -> Bool
apt p = (== p) . genericLength . filter (== 0) . flip map posRoots . inp

