module RootType where


import           E8                  (Vector,gen,posRoots,inp)

import           Control.Applicative ((<$>))
import qualified Data.IntSet as Set
import           Data.List           (foldl')
import           System.Environment  (getArgs)


main :: IO ()
main = do
  d : _ <- map read <$> getArgs
  putStr $ "Root type of d = " ++ show d ++ ": "
  let rt = foldl' (flip Set.insert) Set.empty $ map roots (gen d)
  putStrLn . show . Set.toAscList $ rt

-- Calculate the number of roots a vector is orthogonal to.
roots :: Vector -> Int
roots = (2 *) . length . filter (== 0) . flip map posRoots . inp

