module E7RootType where


import qualified E7
import qualified E8

import           Control.Applicative ((<$>))
import           Data.List           (foldl')
import qualified Data.Set as Set
import           System.Environment  (getArgs)


main :: IO ()
main = do
  d : _ <- map read <$> getArgs
  putStr $ "Root type of d = " ++ show d ++ ": "
  let rt = foldl' (flip Set.insert) Set.empty $ map roots (E7.gen d)
  putStrLn . show . Set.toAscList $ rt

-- Calculate the number of roots a vector is orthogonal to.
roots :: E8.Vector -> Int
roots = (2 *) . length . filter (== 0) . flip map E7.posRoots . E8.inp
