\name{solve.cubic}
\alias{solve.cubic}
\title{
Solves a complex cubic equation
}
\description{
A cubic equation solver based on the Italian mathematicians of the 16th 
century. 
}
\usage{
\method{solve}{cubic}(a,b=NULL,...)
}
\arguments{
  \item{a}{An object of class \env{cubic}.} 
  \item{b}{A ghost argument for S3 generic consistency.} 
  \item{\dots}{Another ghost argument for S3 generic consistency.} 
}

\details{
Uses Cardano's method of solving cubic equations for complex 
coefficients (not tested here - the coefficients for the 
\env{cubic}s here should be restricted to the reals. 
}
\value{An object of class \env{roots}.}
\author{
Matt Nunes
}
\note{
Note that this gives an object in the \env{roots} class, and whilst the  
\code{roots} package is not specifically needed here, it will be for 
other \env{cubic} generics.
}
\seealso{
\code{\link{cubic}}}
\examples{
#define a cubic to solve

x<-cubic(runif(4))

#fingers crossed, this should give what you want.
solve.cubic(x)

}
\keyword{manip}
